<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly

if ( ! class_exists( 'WPDesk_Flexible_Shipping_SaaS_Settings_Connection' ) ) {

	/**
	 * Class WPDesk_Flexible_Shipping_SaaS_Settings_Connection
	 */
	class WPDesk_Flexible_Shipping_SaaS_Auth_Platform_Factory {
		const SAAS_PLATFORM_LOGGER_SOURCE = 'saas-platform';

		const ONE_HOUR = 3600;

		/** @var \Psr\Log\LoggerInterface */
		private $logger;

		/**
		 * WPDesk_Flexible_Shipping_SaaS_Auth_Platform_Factory constructor.
		 *
		 * @param \Psr\Log\LoggerInterface $logger Logger.
		 */
		public function __construct( \Psr\Log\LoggerInterface $logger ) {
			$this->logger = new WPDesk_Flexible_Shipping_WooCommerce_Context_Logger(
				$logger,
				self::SAAS_PLATFORM_LOGGER_SOURCE
			);
		}

		/**
		 * Get platform.
		 *
		 * @return \WPDesk\SaasPlatformClient\Platform
		 */
		public function get_platform() {
			$platform_options = new \WPDesk\SaasPlatformClient\PlatformFactoryWordpressOptions();
			$platform_options->setLogger( $this->logger );
			// TODO: enable when ready
			//$platform_options->setCachedClient( true );
			$platform_options->setCacheTtl( self::ONE_HOUR );
			$platform = \WPDesk\SaasPlatformClient\PlatformFactory::createPlatformApi( $platform_options );

			return $platform;
		}
	}

}
