<?php

namespace WPDesk\SaasPlatformClient\Response;

class RawResponse implements Response
{
    const RESPONSE_CODE_SUCCESS = 200;
    const RESPONSE_CODE_CREATED = 201;
    const RESPONSE_CODE_ERROR_BAD_REQUEST = 400;
    const RESPONSE_CODE_ERROR_FATAL = 500;
    const RESPONSE_CODE_MAINTENANCE = 503;

    /** @var array */
    private $data;

    /** @var int */
    private $code;

    /**
     * RawResponse constructor.
     * @param array $body
     * @param int $code
     */
    public function __construct(array $body, $code)
    {
        $this->data = $body;
        $this->code = (int)$code;
    }

    /**
     * Returns response http code
     *
     * @return int
     */
    public function getResponseCode()
    {
        return $this->code;
    }

    /**
     * Returns response body as array
     *
     * @return array
     */
    public function getResponseBody()
    {
        return $this->data;
    }

    /**
     * Returns response body as array
     *
     * @return array
     */
    public function getResponseErrorBody()
    {
        return $this->data;
    }

    /**
     * Is any error occured
     *
     * @return bool
     */
    public function isError()
    {
        $code = $this->getResponseCode();
        return ( $code < 200 || $code >= 300 ) && !$this->isMaintenance();
    }

    /**
     * Is maintenance.
     *
     * @return bool
     */
    public function isMaintenance()
    {
        $code = $this->getResponseCode();
        return self::RESPONSE_CODE_MAINTENANCE === $code;
    }

}