<?php

use WPDesk\SaasPlatformClient\Authentication\JWTToken;
use WPDesk\SaasPlatformClient\Persistence\MemoryContainer;
use WPDesk\SaasPlatformClient\PlatformFactory;
use WPDesk\SaasPlatformClient\PlatformFactoryOptions;

class TestMemoryContainer extends \PHPUnit\Framework\TestCase
{
    /** @var  \WPDesk\SaasPlatformClient\Platform */
    private $platform;

    /** @var \WPDesk\SaasPlatformClient\Persistence\PersistentContainer */
    private $persistence;

    protected function setUp()
    {
        $options = new PlatformFactoryOptions();
        $options->setPersistenceClass(MemoryContainer::class);

        $this->platform = PlatformFactory::createPlatformApi($options);
        $this->persistence = $this->platform->getPersistentContainer();
    }

    public function testGetterSetter(){
        $this->persistence->set('token', 'whateverTokenValue');
        $this->assertEquals('whateverTokenValue', $this->persistence->get('token'));
    }

    public function testPlatformTokenPersistence() {
        $token = new JWTToken('whateverTokenValue');
        $this->platform->setToken($token);
        $this->assertEquals($token->__toString(), unserialize($this->persistence->get('token'))->__toString());
    }
}