<?php
/*
    "WordPress Plugin Template" Copyright (C) 2016 Michael Simpson  (email : michael.d.simpson@gmail.com)

    This file is part of WordPress Plugin Template for WordPress.

    WordPress Plugin Template is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    WordPress Plugin Template is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Contact Form to Database Extension.
    If not, see http://www.gnu.org/licenses/gpl-3.0.html
*/

abstract class PostmenWoocommercePlugin_ShortCodeLoader {

	/**
	 * @param  $shortcodeName mixed either string name of the shortcode
	 * (as it would appear in a post, e.g. [shortcodeName])
	 * or an array of such names in case you want to have more than one name
	 * for the same shortcode
	 *
	 * @return void
	 */
	public function register( $shortcodeName ) {
		$this->registerShortcodeToFunction( $shortcodeName, 'handleShortcode' );
	}

	/**
	 * @param  $shortcodeName mixed either string name of the shortcode
	 * (as it would appear in a post, e.g. [shortcodeName])
	 * or an array of such names in case you want to have more than one name
	 * for the same shortcode
	 * @param  $functionName string name of public function in this class to call as the
	 * shortcode handler
	 *
	 * @return void
	 */
	protected function registerShortcodeToFunction( $shortcodeName, $functionName ) {
		if ( is_array( $shortcodeName ) ) {
			foreach ( $shortcodeName as $aName ) {
				add_shortcode( $aName, [ $this, $functionName ] );
			}
		} else {
			add_shortcode( $shortcodeName, [ $this, $functionName ] );
		}
	}

	/**
	 * @abstract Override this function and add actual shortcode handling here
	 *
	 * @param  $atts shortcode inputs
	 *
	 * @return string shortcode content
	 */
	public abstract function handleShortcode( $atts );

}
