<?php

/*
Copyright (C) 2016-2017 Pimwick, LLC

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/

defined( 'ABSPATH' ) or exit;

foreach( $order->get_items( 'pw_gift_card' ) as $line ) {
    $gift_card = new PW_Gift_Card( $line->get_card_number() );
    if ( $gift_card->get_id() ) {
        $check_balance_url = $gift_card->check_balance_url();
    } else {
        $check_balance_url = admin_url();
    }

    ?>
    <tr>
        <td class="label">
            <?php _e( 'PW Gift Card', 'pw-woocommerce-gift-cards' ); ?> <a href="<?php echo $check_balance_url; ?>"><?php echo $line->get_card_number(); ?></a>:
        </td>
        <td width="1%"></td>
        <td class="total">
            <?php
                echo wc_price( $line->get_amount() * -1 );
            ?>
        </td>
    </tr>
    <?php
}
