<?php
	
	defined( 'ABSPATH' ) or die( 'Keep Silent' );
	
	add_filter( 'woocommerce_loop_add_to_cart_args', 'wvs_pro_loop_add_to_cart_args', 20, 2 );
	
	// add_filter( 'woocommerce_loop_add_to_cart_link', 'wvs_pro_loop_add_to_cart_link', 20, 3 );
	
	add_action( 'init', function () {
		
		$position = trim( woo_variation_swatches()->get_option( 'archive_swatches_position' ) );
		$priority = ( 'after' === $position ? 30 : 7 );
		add_action( 'woocommerce_after_shop_loop_item', 'wvs_pro_archive_variation_template', $priority );
		
		// Some theme doesn't use "woocommerce_after_shop_loop_item" hook. They can use this for variation template
		// If you need changing position use this on woocommerce/content-product.php like:
		// do_action('wvs_pro_variation_show_archive_variation_before_cart_button');
		// do_action('wvs_pro_variation_show_archive_variation_after_cart_button');
		add_action( sprintf( 'wvs_pro_variation_show_archive_variation_%s_cart_button', $position ), 'wvs_pro_archive_variation_template' );
	} );
	
	
	// Some theme doesn't use "woocommerce_after_shop_loop_item" hook. They can use this for variation template
	// If you need changing position use this on woocommerce/content-product.php like:
	// do_action('wvs_pro_variation_show_archive_variation');
	add_action( 'wvs_pro_variation_show_archive_variation', 'wvs_pro_archive_variation_template' );
	
	
	add_filter( 'post_class', 'wvs_pro_product_loop_post_class', 25, 3 );
	
	add_filter( 'woocommerce_get_script_data', 'wvs_pro_wc_get_script_data', 10, 2 );
	
	add_action( 'wp_ajax_nopriv_wvs_add_variation_to_cart', 'wvs_pro_add_to_cart' );
	
	add_action( 'wp_ajax_wvs_add_variation_to_cart', 'wvs_pro_add_to_cart' );
	
	add_action( 'wp_ajax_nopriv_wvs_get_available_variations', 'wvs_pro_get_available_variations' );
	
	add_action( 'wp_ajax_wvs_get_available_variations', 'wvs_pro_get_available_variations' );
	
	add_filter( 'woocommerce_product_add_to_cart_url', 'wvs_simple_product_cart_url', 10, 2 );
	
	add_filter( 'wvs_available_attributes_types', 'wvs_pro_radio_attribute_type' );
	
	add_filter( 'wvs_product_taxonomy_meta_fields', function ( $old_fields ) {
		
		$fields = array(
			array(
				'label'   => esc_html__( 'Show Tooltip', 'woo-variation-swatches-pro' ), // <label>
				'desc'    => esc_html__( 'Individually show or hide tooltip.', 'woo-variation-swatches-pro' ), // description
				'id'      => 'show_tooltip', // name of field
				'type'    => 'select',
				'options' => array(
					'text'  => esc_html__( 'Text', 'woo-variation-swatches-pro' ),
					'image' => esc_html__( 'Image', 'woo-variation-swatches-pro' ),
					'no'    => esc_html__( 'No', 'woo-variation-swatches-pro' ),
				)
			),
			array(
				'label'      => esc_html__( 'Tooltip text', 'woo-variation-swatches-pro' ), // <label>
				'desc'       => esc_html__( 'Tooltip text. Default tooltip text will be term name.', 'woo-variation-swatches-pro' ), // description
				'id'         => 'tooltip_text', // name of field
				'type'       => 'text',
				'dependency' => array(
					array( '#show_tooltip' => array( 'type' => 'equal', 'value' => 'text' ) )
				)
			),
			array(
				'label'      => esc_html__( 'Tooltip image', 'woo-variation-swatches-pro' ), // <label>
				'desc'       => esc_html__( 'Tooltip image. Default tooltip text will be term name.', 'woo-variation-swatches-pro' ), // description
				'id'         => 'tooltip_image', // name of field
				'type'       => 'image',
				'dependency' => array(
					array( '#show_tooltip' => array( 'type' => 'equal', 'value' => 'image' ) )
				)
			)
		);
		
		$specific_fields = array(
			'image' => array(
				'label'   => esc_html__( 'Image Size', 'woo-variation-swatches-pro' ), // <label>
				'desc'    => esc_html__( 'Choose Image size, ( this will override global settings )', 'woo-variation-swatches-pro' ), // description
				'id'      => 'image_size', // name of field
				'type'    => 'select',
				'options' => array_reduce( get_intermediate_image_sizes(), function ( $carry, $item ) {
					$carry[ $item ] = ucwords( str_ireplace( array( '-', '_' ), ' ', $item ) );
					
					return $carry;
				}, array() )
			)
		);
		
		$keys = array_keys( wvs_available_attributes_types() );
		
		foreach ( $keys as $key ) {
			if ( ! isset( $old_fields[ $key ] ) ) {
				$old_fields[ $key ] = array();
			}
			
			foreach ( $fields as $field ) {
				array_push( $old_fields[ $key ], $field );
			}
			
			foreach ( $specific_fields as $specific_key => $specific_field ) {
				if ( $specific_key === $key ) {
					array_push( $old_fields[ $specific_key ], $specific_field );
				}
			}
		}
		
		return $old_fields;
	} );
	
	add_action( 'after_wvs_settings', function () {
		woo_variation_swatches()->add_setting( 'style', esc_html__( 'Style', 'woo-variation-swatches-pro' ), array(
			array(
				'title'  => esc_html__( 'Visual Styling', 'woo-variation-swatches-pro' ),
				'desc'   => esc_html__( 'Change some visual styles', 'woo-variation-swatches-pro' ),
				'fields' => apply_filters( 'wvs_pro_style_setting_fields', array(
					array(
						'id'                          => 'tooltip_background_color',
						'type'                        => 'color',
						'title'                       => esc_html__( 'Tooltip background', 'woo-variation-swatches-pro' ),
						'desc'                        => esc_html__( 'Tooltip background color', 'woo-variation-swatches-pro' ),
						'default'                     => 'rgba(51, 51, 51, 0.9)',
						'alpha'                       => TRUE,
						'customize_control_class'     => 'WVS_Customize_Alpha_Color_Control',
						'customize_sanitize_callback' => 'sanitize_text_field',
					),
					array(
						'id'                          => 'tooltip_text_color',
						'type'                        => 'color',
						'title'                       => esc_html__( 'Tooltip text color', 'woo-variation-swatches-pro' ),
						'desc'                        => esc_html__( 'Tooltip text color', 'woo-variation-swatches-pro' ),
						'default'                     => '#ffffff',
						'alpha'                       => TRUE,
						'customize_control_class'     => 'WVS_Customize_Alpha_Color_Control',
						'customize_sanitize_callback' => 'sanitize_text_field',
					),
					array(
						'id'      => 'tooltip_image_width',
						'type'    => 'number',
						'title'   => esc_html__( 'Tooltip image width', 'woo-variation-swatches-pro' ),
						'desc'    => esc_html__( 'Tooltip image width', 'woo-variation-swatches-pro' ),
						'default' => '100',
						'suffix'  => 'px',
					),
					array(
						'id'                          => 'border_color',
						'type'                        => 'color',
						'title'                       => esc_html__( 'Item border color', 'woo-variation-swatches-pro' ),
						'desc'                        => esc_html__( 'Swatches item border color', 'woo-variation-swatches-pro' ),
						'default'                     => 'rgba(0, 0, 0, 0.3)',
						'alpha'                       => TRUE,
						'customize_control_class'     => 'WVS_Customize_Alpha_Color_Control',
						'customize_sanitize_callback' => 'sanitize_text_field',
					),
					array(
						'id'      => 'border_size',
						'type'    => 'number',
						'title'   => esc_html__( 'Item border size', 'woo-variation-swatches-pro' ),
						'desc'    => esc_html__( 'Swatches item border size', 'woo-variation-swatches-pro' ),
						'default' => 1,
						'min'     => 1,
						'max'     => 5,
						'size'    => 'tiny',
						'suffix'  => esc_html__( 'px', 'woo-variation-swatches-pro' )
					),
					array(
						'id'      => 'hover_border_size',
						'type'    => 'number',
						'title'   => esc_html__( 'Item hover border size', 'woo-variation-swatches-pro' ),
						'desc'    => esc_html__( 'Swatches item hover border size', 'woo-variation-swatches-pro' ),
						'default' => 3,
						'min'     => 1,
						'max'     => 5,
						'size'    => 'tiny',
						'suffix'  => esc_html__( 'px', 'woo-variation-swatches-pro' )
					),
					array(
						'id'                          => 'selected_border_color',
						'type'                        => 'color',
						'title'                       => esc_html__( 'Selected item border color', 'woo-variation-swatches-pro' ),
						'desc'                        => esc_html__( 'Swatches selected item border color', 'woo-variation-swatches-pro' ),
						'default'                     => 'rgba(0, 0, 0, 0.9)',
						'alpha'                       => TRUE,
						'customize_control_class'     => 'WVS_Customize_Alpha_Color_Control',
						'customize_sanitize_callback' => 'sanitize_text_field',
					),
					array(
						'id'      => 'selected_border_size',
						'type'    => 'number',
						'title'   => esc_html__( 'Selected item border size', 'woo-variation-swatches-pro' ),
						'desc'    => esc_html__( 'Swatches selected item border size', 'woo-variation-swatches-pro' ),
						'default' => 2,
						'min'     => 1,
						'max'     => 5,
						'size'    => 'tiny',
						'suffix'  => esc_html__( 'px', 'woo-variation-swatches-pro' )
					),
					array(
						'id'                          => 'text_color',
						'type'                        => 'color',
						'title'                       => esc_html__( 'Item text color', 'woo-variation-swatches-pro' ),
						'desc'                        => esc_html__( 'Swatches item text color', 'woo-variation-swatches-pro' ),
						'default'                     => '#000000',
						'alpha'                       => TRUE,
						'customize_control_class'     => 'WVS_Customize_Alpha_Color_Control',
						'customize_sanitize_callback' => 'sanitize_text_field',
					),
					array(
						'id'                          => 'background_color',
						'type'                        => 'color',
						'title'                       => esc_html__( 'Item background color', 'woo-variation-swatches-pro' ),
						'desc'                        => esc_html__( 'Swatches item background color', 'woo-variation-swatches-pro' ),
						'default'                     => '#FFFFFF',
						'alpha'                       => TRUE,
						'customize_control_class'     => 'WVS_Customize_Alpha_Color_Control',
						'customize_sanitize_callback' => 'sanitize_text_field',
					)
				) )
			)
		), apply_filters( 'wvs_pro_style_setting_default_active', FALSE ) );
		
		woo_variation_swatches()->add_setting( 'archive', esc_html__( 'Archive / Shop', 'woo-variation-swatches-pro' ), array(
			array(
				'title'  => esc_html__( 'Visual Section', 'woo-variation-swatches-pro' ),
				'desc'   => esc_html__( 'Advanced change some visual styles', 'woo-variation-swatches-pro' ),
				'fields' => apply_filters( 'wvs_pro_archive_setting_fields', array(
					array(
						'id'      => 'show_on_archive',
						'type'    => 'checkbox',
						'title'   => esc_html__( 'Enable Swatches', 'woo-variation-swatches-pro' ),
						'desc'    => esc_html__( 'Show swatches on archive / shop page.', 'woo-variation-swatches-pro' ),
						'default' => TRUE
					),
					array(
						'id'      => 'archive_swatches_position',
						'type'    => 'radio',
						'title'   => esc_html__( 'Display position', 'woo-variation-swatches-pro' ),
						'desc'    => esc_html__( 'Show archive swatches position', 'woo-variation-swatches-pro' ),
						'default' => 'after',
						'options' => array(
							'before' => esc_html__( 'Before add to cart button', 'woo-variation-swatches-pro' ),
							'after'  => esc_html__( 'After add to cart button', 'woo-variation-swatches-pro' )
						)
					),
					array(
						'id'      => 'archive_align',
						'type'    => 'select',
						'size'    => 'tiny',
						'title'   => esc_html__( 'Swatches align', 'woo-variation-swatches-pro' ),
						'desc'    => esc_html__( 'Swatches align on archive page', 'woo-variation-swatches-pro' ),
						'default' => 'left',
						'options' => array(
							'left'   => esc_html__( 'Left', 'woo-variation-swatches-pro' ),
							'center' => esc_html__( 'Center', 'woo-variation-swatches-pro' ),
							'right'  => esc_html__( 'Right', 'woo-variation-swatches-pro' )
						)
					),
					array(
						'id'      => 'show_tooltip_on_archive',
						'type'    => 'checkbox',
						'title'   => esc_html__( 'Enable tooltip', 'woo-variation-swatches' ),
						'desc'    => esc_html__( 'Show tooltip on archive / shop page.', 'woo-variation-swatches-pro' ),
						'default' => TRUE
					),
					array(
						'id'      => 'show_clear_on_archive',
						'type'    => 'checkbox',
						'title'   => esc_html__( 'Show clear link', 'woo-variation-swatches' ),
						'desc'    => esc_html__( 'Show clear link on archive / shop page.', 'woo-variation-swatches-pro' ),
						'default' => TRUE
					),
					array(
						'id'      => 'archive_width',
						'type'    => 'number',
						'title'   => esc_html__( 'Item Width', 'woo-variation-swatches' ),
						'desc'    => __( 'Variation item width on archive page', 'woo-variation-swatches' ),
						'default' => 30,
						'min'     => 10,
						'max'     => 200,
						'suffix'  => 'px'
					),
					array(
						'id'      => 'archive_height',
						'type'    => 'number',
						'title'   => esc_html__( 'Item Height', 'woo-variation-swatches' ),
						'desc'    => __( 'Variation item height on archive page', 'woo-variation-swatches' ),
						'default' => 30,
						'min'     => 10,
						'max'     => 200,
						'suffix'  => 'px'
					),
					array(
						'id'      => 'archive_font_size',
						'type'    => 'number',
						'title'   => esc_html__( 'Item Font Size', 'woo-variation-swatches' ),
						'desc'    => __( 'Archive product variation item font size', 'woo-variation-swatches' ),
						'default' => 16,
						'min'     => 8,
						'max'     => 24,
						'suffix'  => 'px'
					)
				) )
			)
		), apply_filters( 'wvs_pro_archive_setting_default_active', FALSE ) );
		
		woo_variation_swatches()->add_setting( 'license', esc_html__( 'License Key', 'woo-variation-swatches-pro' ), array(
			array(
				'title'            => esc_html__( 'License Section', 'woo-variation-swatches-pro' ),
				'desc'             => esc_html__( 'Product license key', 'woo-variation-swatches-pro' ),
				'customize_hidden' => TRUE,
				'fields'           => array(
					array(
						'id'      => 'license_key',
						'type'    => 'text',
						'title'   => esc_html__( 'License Key', 'woo-variation-swatches' ),
						'desc'    => sprintf( __( 'Please add product license key and add your domain(s) on <a target="_blank" href="%s">GetWooPlugins.com -> My Downloads</a> to get automatic update.', 'woo-variation-swatches-pro' ), 'https://getwooplugins.com/my-account/downloads/' ),
						'default' => '',
					),
				)
			)
		), FALSE );
		
	} );
	
	add_filter( 'wvs_advanced_setting_fields', function ( $fields ) {
		// unset( $fields[ 'advanced-pro' ] );
		
		$field = array(
			array(
				'id'      => 'disable_threshold',
				'type'    => 'checkbox',
				'title'   => esc_html__( 'Disable ajax threshold', 'woo-variation-swatches' ),
				'desc'    => esc_html__( 'Disable ajax variation threshold to make all variation work like non ajax style.', 'woo-variation-swatches' ),
				'default' => FALSE
			)
		);
		
		array_splice( $fields, 2, 0, $field );
		
		return $fields;
	} );
	
	add_filter( 'wvs_variation_attribute_options_html', function ( $data, $args ) {
		$product          = $args[ 'product' ];
		$options          = $args[ 'options' ];
		$attribute        = $args[ 'attribute' ];
		$saved_attributes = get_post_meta( $product->get_id(), '_wvs_product_attributes', TRUE );
		$id               = sanitize_title( $attribute );
		
		if ( empty( $saved_attributes ) ) {
			return $data;
		} else {
			if ( isset( $saved_attributes[ $id ] ) ) {
				$saved_attribute = $saved_attributes[ $id ];
				
				ob_start();
				
				$args[ 'type' ] = isset( $args[ 'type' ] ) ? $args[ 'type' ] : $saved_attribute[ 'type' ];
				wvs_pro_variation_attribute_options( $args, $saved_attribute[ 'type' ] != 'select' );
				
				if ( $saved_attribute[ 'type' ] !== 'select' ) {
					
					$content = wvs_variable_item( $saved_attribute[ 'type' ], $options, $args, $saved_attribute );
					
					echo wvs_variable_items_wrapper( $content, $saved_attribute[ 'type' ], $args, $saved_attribute );
				}
				
				return ob_get_clean();
				
			} else {
				return $data;
			}
		}
	}, 10, 2 );
	
	add_filter( 'wvs_variable_items_wrapper_class', function ( $classes, $type, $args, $saved_attribute ) {
		
		$class = array();
		if ( $saved_attribute ) {
			$type = $saved_attribute[ 'type' ];
			
			//$show_tooltip = $saved_attribute[ 'tooltip' ] === 'yes';
			$style = $saved_attribute[ 'style' ];
			
			$class[] = "{$type}-variable-wrapper";
			
			$class[] = $style;
			
			return $class;
		}
		
		return $classes;
	}, 10, 4 );