<?php
	defined( 'ABSPATH' ) or die( 'Keep Silent' );
	
	$attributes           = $args[ 'options' ][ 'variations' ][ 'attributes' ];
	$attribute_keys       = array_keys( $attributes );
	$available_variations = $args[ 'options' ][ 'variations' ][ 'available_variations' ];
	$product              = $args[ 'product' ];
	
	if ( empty( $available_variations ) && FALSE !== $available_variations ) {
		return;
	}
	
	if ( ! woo_variation_swatches()->get_option( 'show_on_archive' ) ) {
		return;
	}
	
	$show_clear = woo_variation_swatches()->get_option( 'show_clear_on_archive' );
?>

<div class="variations_form wvs-archive-variation-wrapper" data-product_id="<?php echo absint( $product->get_id() ); ?>" data-product_variations="<?php echo htmlspecialchars( wp_json_encode( $available_variations ) ) ?>">
    <ul class="variations">
		<?php foreach ( $attributes as $attribute_name => $options ) : ?>
            <li>
				<?php
					$selected = isset( $_REQUEST[ 'attribute_' . sanitize_title( $attribute_name ) ] ) ? wc_clean( stripslashes( urldecode( $_REQUEST[ 'attribute_' . sanitize_title( $attribute_name ) ] ) ) ) : $product->get_variation_default_attribute( $attribute_name );
					wc_dropdown_variation_attribute_options( array( 'options' => $options, 'attribute' => $attribute_name, 'product' => $product, 'selected' => $selected, 'is_archive' => TRUE ) );
				?>
            </li>
		<?php endforeach; ?>
		<?php
			if ( $show_clear ):
				echo apply_filters( 'woocommerce_reset_variations_link', '<li class="reset_variations"><a href="#">' . esc_html__( 'Clear', 'woocommerce' ) . '</a></li>' );
			endif;
		?>
    </ul>
</div>

