<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! class_exists( 'WCRP_Second_Payment_Reminder' ) ) :

	/**
	 * WCRP_Second_Payment_Reminder class file.
	 *
	 * @author Flipper Code <hello@flippercode.com>
	 * @package woocommerce-reminder-pro
	 */
	class WCRP_Second_Payment_Reminder extends WC_Email
	{
		private $getwooSetting;
		private $dboptions;
		private $email_placeholder;
		private $sms_placeholder;
		
		function __construct()
		{
		$this->getwooSetting    =get_option('woocommerce_second_payment_reminder_settings');
		$this->dboptions 		= get_option( 'woocommerce-reminder-pro' );			
		$this->id               = 'second_payment_reminder';
		$this->customer_email   = true;
		$this->title            = __( 'Second Payment Reminder', WCRP_TEXT_DOMAIN );
		$this->description      = __( 'Customers "Second Payment Reminder" emails sent to customers when payment status is pending', WCRP_TEXT_DOMAIN);
		$this->heading          = __( 'Second Payment Reminder', WCRP_TEXT_DOMAIN );
		$this->subject          = __( 'Second Payment Reminder', WCRP_TEXT_DOMAIN );
		$this->mail_body        = isset($this->getwooSetting['mail_body']) ? $this->getwooSetting['mail_body'] :__('Hello {billing_first_name} {billing_last_name},<br><br>
			This is Second pending payment reminder for an order #{order_no} that you have placed at our site {site_name}.
			Please make payment using below link so that we can ship the products on your specified billing address.<br>
			{payment_link}<br><br>
			{order_info_table}<br>
			{customer_details}<br>
			{billing_details}<br>
			<br><br>
			Thanks<br>
			{site_name}',WCRP_TEXT_DOMAIN );
		$this->sms_content		= isset($this->getwooSetting['sms_content'])?$this->getwooSetting['sms_content'] :__('Please make payment for order #{order_no}  @ {site_name} to get all products shipped.',WCRP_TEXT_DOMAIN);
		$this->email_placeholder  = __('Enter / Customize the main email content you want to send in delivery reminder email to user. You can use the following placeholder in above text box.',WCRP_TEXT_DOMAIN);
		$this->sms_placeholder    = __('Enter / Customize the main sms content you want to send in delivery reminder sms to user. You can use the following placeholder in above text box. Please enter sms body with minimum amount of 160 characters. For more information please check < a href="https://support.twilio.com/hc/en-us/articles/223181508-Does-Twilio-support-concatenated-SMS-messages-or-messages-over-160-characters-" target="_blank"> here</a>.',WCRP_TEXT_DOMAIN);
		$this->sms_placeholder    .=__('<table class="fc-placeholders-listing"><thead><tr><th>Placeholder Name</th><th>Placeholder Value</th></tr></thead><tbody><tr><td>{order_no}</td><td>Order No.</td></tr><tr><td>{billing_first_name}</td><td>Customer First Name</td></tr><tr><td>{billing_last_name}</td><td>Customer Last Name</td></tr><tr>
		<td>{products_name}</td><td> Products of Order like-<b> Happy Ninja, Woo Album,</b> etc.</td></tr><tr><td>{site_name}</td><td>Your Website Title</td></tr><tr><td>{site_url}</td><td>Your Website URL</td></tr><tr><td>{payment_method}</td><td>Order Payment Method</td></tr><tr><td>{payment_link}</td><td>Recheckout Payment Link</td></tr><tr><td>{sms_payment_link}</td><td>Recheckout Payment Link in SMS</td></tr>		<tr><td>{order_info_table}</td><td>Oder Details Information</td></tr><tr><td>{customer_details}</td><td>Oder Details Information</td></tr><tr><td>{billing_details}</td><td>Shipping Address</td></tr></tbody></table>', WCRP_TEXT_DOMAIN);
		
		$this->reminder_days     = isset($this->getwooSetting['reminderdays'])?$this->getwooSetting['reminderdays'] :7;
		parent::__construct();
			
		}
		public function trigger( $order_id ) {
			if ( $order_id ) {
				$this->object         = wc_get_order( $order_id );
				$this->find['order-date']      = '{order_date}';
				$this->find['order-number']    = '{order_number}';
				$this->replace['order-date']   = date_i18n( wc_date_format(), strtotime( $this->object->get_date_created() ) );
				$this->replace['order-number'] = $this->object->get_order_number();
			}
			
			$this->recipient =$this->object->get_billing_email();	
			
			if ( ! $this->is_enabled() || ! $this->get_recipient() ) {
				return;
			}
			
			$success = $this->send( $this->get_recipient(), $this->get_subject(), $this->get_content(), $this->get_headers(), $this->get_attachments() );
			unset($this->object);
			return $success;
		}
	
		public function trigger_sms($order_id){
			if(!is_array($this->dboptions ))
			$this->dboptions = unserialize($this->dboptions);
			$AccountSid = isset($this->dboptions['wcrp_twilio_accountsid'])?$this->dboptions['wcrp_twilio_accountsid']:'';
			$AuthToken = isset($this->dboptions['wcrp_twilio_authtoken'])?$this->dboptions['wcrp_twilio_authtoken']:'';
			$From  = isset($this->dboptions['wcrp_twilio_from_number']) ? $this->dboptions['wcrp_twilio_from_number'] : '';	
			$order = wc_get_order( $order_id );
			$billingphone = $order->get_billing_phone();
			$sms  = $backupsms = $this->sms_content;
			$sms  = $this->collect_placeholder_and_replace($order,$sms);
			$sms  =strip_tags($sms); 
			$data = array('to'=>$billingphone,'sms'=>$sms);
			$to   = $data['to'];
			$sms  = $data['sms'];
		    $client = new TwilioRestClient($AccountSid, $AuthToken);
		    $data   = array(
		    	"From" => $From,
		    	"To" => $to,
		    	"Body" => $sms
		    );
		    $response = $client->request("/2008-08-01/Accounts/$AccountSid/SMS/Messages", "POST", $data);
			if($response->IsError) {

				if($response->ResponseXml->RestException->Code=="21605"){

					$backupsms = $this->replace_fallback_placeholder($order,$backupsms);	
					$backupsms  = strip_tags($backupsms); 
					$data['Body'] = $backupsms;

					$fallback_response = $client->request("/2008-08-01/Accounts/$AccountSid/SMS/Messages", "POST", $data);

					if($fallback_response->IsError) {
						 $status = 'error';
					}
					else {
					 	 $status = 'success';
					}
				}else{
					 $status = 'error';
				}
			}
			else {
			  $status = 'success';
			}
			
		  return $status;
		}

		public function replace_fallback_placeholder($order,$backupsms){

	   		$toReplace = array(
								'products_name'=>'',
								'payment_link'=>'',
								'sms_payment_link'=>'',
								);
			$backupsms = $this->replace_placeholders($backupsms, $toReplace);
			$backupsms = $this->collect_placeholder_and_replace($order, $backupsms);
			return $backupsms;
	   	} 

		public function collect_placeholder_and_replace($order,$content){
			$sent_to_admin = false;
	        $plain_text    = false;

			$billingphone = $order->get_billing_phone();
			$order_id = $order->get_id();
			$billing_first_name = $order->get_billing_first_name();
			$billing_last_name  = $order->get_billing_last_name();
			$items = $order->get_items();
			$product_link_html = '';
			$counter= 0;
			foreach ($items as $item) { 
				$product_link_html .='<strong>';
				$product_link_html .= ucwords($item['name']);
				if($counter==(count($items)-1)){
					$product_link_html .='</strong>';
				}else{
					$product_link_html .='</strong>, ';
				}

				$counter++;
			}

			ob_start();
		    wc_get_template( 'emails/email-order-details.php', array( 'order' => $order, 'sent_to_admin' => false, 'plain_text' => false, 'email' => $this ) );
		    $order_details = ob_get_contents();
		    ob_get_clean();


			ob_start();
			$fields = array();
			if ( $order->get_billing_email() ) {
				$fields['billing_email'] = array(
					'label' => __( 'Email', WCRP_TEXT_DOMAIN ),
					'value' => wptexturize( $order->get_billing_email() )
				);
			}

			if ( $order->get_billing_phone() ) {
				$fields['billing_phone'] = array(
					'label' => __( 'Tel', WCRP_TEXT_DOMAIN ),
					'value' => wptexturize( $order->get_billing_phone() )
				);
			}
			wc_get_template( 'emails/email-customer-details.php', array( 'fields' => $fields ) );
			$customer_details = ob_get_contents();
			ob_get_clean();


			ob_start();
			wc_get_template( 'emails/email-addresses.php', array( 'order' => $order ) );
			$shipping_address = ob_get_contents();
			ob_get_clean();

			$payment_method = $order->get_payment_method();
			$payment_link   = $order->get_checkout_payment_url();
			$checkout_button  ='';
			$checkoutlable    =__('Proceed to Checkout', WCRP_TEXT_DOMAIN);
		    $checkout_button .='<br><a style="padding: 10px 18px;border: none !important;cursor: pointer;border-radius: 0px;transition: all 0.5s;text-align: center;background: #557da1;color: #fff;text-decoration: none;" href="'. esc_url($payment_link) .'" target="_blank">'.$checkoutlable.'</a>';
			$toReplace = array('billing_first_name' => '<b>'.ucwords($billing_first_name).'</b>',
								'billing_last_name' => '<b>'.ucwords($billing_last_name).'</b>',
								'order_no'=>'<b>'.$order_id.'</b>',
								'site_name'=>get_bloginfo('name'),
								'site_url'=>get_bloginfo('url'),
								'products_name'=>$product_link_html,
								'payment_method' =>'<b>'.ucwords($payment_method).'</b>',
								'payment_link'=>$checkout_button,
								'sms_payment_link'=>$payment_link,
								'order_info_table' =>$order_details,
							    'customer_details' =>$customer_details,
							    'billing_details' =>$shipping_address,
								);
			$content = $this->replace_placeholders($content, $toReplace);
			return $content;
		}
			
		// Replace Placeholders from mailbody
		function replace_placeholders($template, $data) {

		    $placeholders = array_keys($data);
		    foreach ($placeholders as &$placeholder) {
		        $placeholder = "{{$placeholder}}";
		    }
		    return str_replace($placeholders, array_values($data), $template);
		}
	
		public function get_content_html() {
					
			  $order = $this->object;
			  $order_id = $this->object->get_id();
			  $email = $this;
			  $email_heading = $this->get_heading();
			
			  ob_start();
			  wc_get_template( 'emails/email-header.php', array( 'email_heading' => $email_heading ) );
			  $order_details_header = ob_get_contents();
			  ob_get_clean();

			  ob_start();
			  wc_get_template( 'emails/email-footer.php' );
			  $footer = ob_get_contents();
			  ob_clean();

			  $payment_link = $order->get_checkout_payment_url();
			  $mail_body = $this->collect_placeholder_and_replace($order,$this->mail_body);
		      $message = $order_details_header. $mail_body.$footer;


		      //$message = apply_filters('wcrp_second_reminder_mail_markup',$order_details_header,$mail_body,$footer,$payment_link,$order_id);
			  return $message;

	   }
	   
		public function init_form_fields() {
			$this->form_fields = array(
				'enabled' => array(
					'title'         => __( 'Enable Email',WCRP_TEXT_DOMAIN),
					'type'          => 'checkbox',
					'label'         => __( 'Enable Second Payment Reminder email notification', WCRP_TEXT_DOMAIN ),
					'default'       => 'yes'
				),
				'sms' => array(
					'title'         => __( 'Enable SMS', WCRP_TEXT_DOMAIN ),
					'type'          => 'checkbox',
					'label'         => __( 'Enable Second Payment Reminder SMS notification', WCRP_TEXT_DOMAIN ),
					'default'       => 'No'
				),
				'reminderdays' => array(
					'title'         => __( 'Second Payment Reminder Email/Sms After Days', WCRP_TEXT_DOMAIN ),
					'type'          => 'number',
					'description'   => __( 'Set Number of days for send Second Payment Reminder Notification(By Default 7 Days)', WCRP_TEXT_DOMAIN ),
					'default'       => $this->reminder_days,
					'desc_tip'      => true,
					'class'			=>'wcrpminrange'
				)
				,
				'subject' => array(
					'title'         => __( 'Subject', WCRP_TEXT_DOMAIN ),
					'type'          => 'text',
					'description'   => sprintf( __( 'This controls the email subject line. Leave blank to use the default subject: <code>%s</code>.', WCRP_TEXT_DOMAIN ), $this->subject ),
					'desc_tip'      => true
				),
				'heading' => array(
					'title'         => __( 'Email Heading', WCRP_TEXT_DOMAIN ),
					'type'          => 'text',
					'description'   => sprintf( __( 'This controls the main heading contained within the email notification. Leave blank to use the default heading: <code>%s</code>.', WCRP_TEXT_DOMAIN ), $this->heading ),
					'desc_tip'      => true
				),
				'email_type' => array(
					'title'         => __( 'Email type', WCRP_TEXT_DOMAIN ),
					'type'          => 'select',
					'description'   => __( 'Choose which format of email to send.', WCRP_TEXT_DOMAIN ),
					'default'       => 'html',
					'class'         => 'email_type wc-enhanced-select',
					'options'       => $this->get_email_type_options(),
					'desc_tip'      => true
				),
				'mail_body' => array(
					'title'         => __( 'Mail Content', WCRP_TEXT_DOMAIN ),
					'type'          => 'textarea',
					'description'   => sprintf( __( ' <code>%s</code>.', WCRP_TEXT_DOMAIN ), $this->email_placeholder ),
					 'rows'			=>'20',
					'default'       => $this->mail_body,
					'desc_tip'      => false
				),
				'sms_content' => array(
					'title'         => __( 'Sms Content', WCRP_TEXT_DOMAIN ),
					'type'          => 'textarea',
					'description'   => sprintf( __( '<code>%s</code>', WCRP_TEXT_DOMAIN ), $this->sms_placeholder ),
					 'rows'			=>'20',
					'default'       => $this->sms_content,
					'desc_tip'      => false
				)
			);
		  }
	
	}
	endif;

