<?php
/**
* Setting page for woocommerce-reminder-pro.
* @author Flipper Code <hello@flippercode.com>
* @version 1.0.3
* @package woocommerce-reminder-pro
*/

$form  = new WCRP_INTRO();
$form->set_header( __( 'Customize Email / SMS Content For Woocommerce Custom Reminder Emails & SMS', WCRP_TEXT_DOMAIN ) , $response);
$data  = unserialize( get_option('woocommerce-reminder-pro') );
$first_payment_link   =  admin_url('admin.php?page=wc-settings&tab=email&section=wcrp_first_payment_reminder');
$second_payment_link  =  admin_url('admin.php?page=wc-settings&tab=email&section=wcrp_second_payment_reminder');
$third_payment_link   =  admin_url('admin.php?page=wc-settings&tab=email&section=wcrp_third_payment_reminder');
$review_reminder_link =  admin_url('admin.php?page=wc-settings&tab=email&section=wcrp_review_pending_reminder');
$delivery_reminder_link =  admin_url('admin.php?page=wc-settings&tab=email&section=wcrp_delivery_reminder');
$new_order_sms =  admin_url('admin.php?page=wc-settings&tab=email&section=wc_email_customer_processing_order');

$form->add_element( 'anchor', 'customize_first_payment', array(
	 'lable' => __( 'Fisrt Pending Payment Reminder',WCRP_TEXT_DOMAIN ),
	 'href' => $first_payment_link, 
	 'class' => 'fc-btn fc-btn-orange btn-small fc-3',
	 'target' => '_blank',
	 'value' =>__('Update Content',WCRP_TEXT_DOMAIN),
	 'id' => 'customize_first_payment'
));

$form->add_element( 'anchor', 'customize_second_payment', array(
	'lable' => __( 'Second Pending Payment Reminder',WCRP_TEXT_DOMAIN ),
	 'href' => $second_payment_link,
	 'class' => 'fc-btn fc-btn-orange  btn-small fc-3',
	 'target' => '_blank',
	 'value' =>__('Update Content',WCRP_TEXT_DOMAIN),
));
$form->add_element( 'anchor', 'customize_third_payment', array(
	'lable' => __( 'Third Pending Payment Reminder',WCRP_TEXT_DOMAIN ),
	 'href' => $third_payment_link,
	 'class' => 'fc-btn fc-btn-orange  btn-small fc-3',
	 'target' => '_blank',
	 'value' =>__('Update Content',WCRP_TEXT_DOMAIN)
));
$form->add_element( 'anchor', 'customize_review_reminder', array(
	'lable' => __( 'Product Review Reminder',WCRP_TEXT_DOMAIN ),
	 'href' => $review_reminder_link,
	 'class' => 'fc-btn fc-btn-orange  btn-small fc-3',
	 'target' => '_blank',
	 'value' =>__('Update Content',WCRP_TEXT_DOMAIN)
));
$form->add_element( 'anchor', 'customize_delivery_reminder', array(
	'lable' => __( 'Product Delivery Reminder',WCRP_TEXT_DOMAIN ),
	 'href' => $delivery_reminder_link,
	 'class' => 'fc-btn fc-btn-orange  btn-small fc-3',
	 'target' => '_blank',
	 'value' =>__('Update Content',WCRP_TEXT_DOMAIN)
));

$form->add_element( 'anchor', 'customize_new_order_sms', array(
	'lable' => __( 'New Order Placed By Customer SMS Notification',WCRP_TEXT_DOMAIN ),
	 'href' => $new_order_sms,
	 'class' => 'fc-btn fc-btn-orange btn-small fc-3',
	 'target' => '_blank',
	 'value' =>__('Update Content',WCRP_TEXT_DOMAIN)
));

$form->add_element( 'group', 'wcrp_twilio_settings', array(
		'value' => __( 'Configure Twilio For Sending SMS ( SMS Gateway )', WCRP_TEXT_DOMAIN ),
		'before' => '<div class="fc-12">',
		'after' => '</div>',

));

$form->add_element( 'checkbox', 'wcrp_enable_twilo', array(
	'lable' => __( 'Enable SMS Sending', WCRP_TEXT_DOMAIN ),
	'value' => 'true',
	'id' => 'date_filters',
	'current' => isset( $data['wcrp_enable_twilo'] ) ? $data['wcrp_enable_twilo'] : '',
	'class' => 'chkbox_class keep_aspect_ratio switch_onoff',
	'data' => array( 'target' => '.enable_wrcp_twilio'),
	'default_value' => 'false',
));

$form->add_element( 'text', 'wcrp_twilio_accountsid', array(
	'lable' => __( ' Account Sid ', WCRP_TEXT_DOMAIN ),
	'value' => isset( $data['wcrp_twilio_accountsid'] ) ? $data['wcrp_twilio_accountsid'] :'',
	'class' => 'form-control enable_wrcp_twilio',
	'placeholder' => __('Account Sid',WCRP_TEXT_DOMAIN),
	'show'=>'false'
));

$form->add_element( 'text', 'wcrp_twilio_authtoken', array(
	'lable' => __( ' Account AuthToken ', WCRP_TEXT_DOMAIN ),
	'value' => isset( $data['wcrp_twilio_authtoken'] ) ? $data['wcrp_twilio_authtoken'] :'',
	'class' => 'form-control enable_wrcp_twilio',
	'placeholder' => __('AuthToken',WCRP_TEXT_DOMAIN),
	'show'=>'false'

));

$form->add_element( 'text', 'wcrp_twilio_from_number', array(
	'lable' => __( ' From Number ', WCRP_TEXT_DOMAIN ),
	'value' => isset( $data['wcrp_twilio_from_number'] ) ? $data['wcrp_twilio_from_number'] :'',
	'class' => 'form-control enable_wrcp_twilio',
	'placeholder' => __('From Number Activated from Twilio',WCRP_TEXT_DOMAIN),
	'show'=>'false',
	'desc' => __( 'Get all above information from your <a href="https://www.twilio.com" target="_blank">Twilio</a> account. The Most Trusted SMS Gateway API.', WCRP_TEXT_DOMAIN ),

));
// Start of Delivery days and date Settings
$form->add_element( 'group', 'delivery_settings_group', array(
	'value' => __( 'Product Delivery  Settings', WCRP_TEXT_DOMAIN ),
	'before' => '<div class="fc-12">',
	'after' => '</div>',

));


$login_type_options = array(
'admin' => __( 'Admin',WCRP_TEXT_DOMAIN ),
'user' => __( 'User',WCRP_TEXT_DOMAIN ),
);

$form->add_element( 'radio', 'delivery_radio_settings', array(
	'lable' => __( 'Delivery Date Set By ', WCRP_TEXT_DOMAIN ),
	'current' => ( isset( $data ['delivery_radio_settings'] ) and ! empty( $data ['delivery_radio_settings'] ) )? $data ['delivery_radio_settings'] :'',
	'radio-val-label' => $login_type_options,
	'default_value' => 'admin',
	'class' => ' switch_onoff',
));

$all_list = array();
for($i=1; $i<=20;$i++ ) {
	$all_list[$i] = $i;
}

$form->add_element( 'text', 'set_delivery_days', array(
	'id' => 'set_delivery_days',
	'lable' => __( 'Minimum Gap Days Between Order Date & Delivery Date',WCRP_TEXT_DOMAIN ),
	'value' => (isset( $data['set_delivery_days'] ) and ! empty( $data['set_delivery_days'] )) ? $data['set_delivery_days'] : '',
	'desc'=>__('Minimum Gap Days Between Order Date And Product Delivery Date. This gap days can be preserved for doing product delivery with ease and user on checkout form will be able to specify only future delivery dates for shipping of products. For eg. If you set gap as 5 days, on frontend @ checkout form, the datepicker field will display/enable dates which are 5 days ahead from today.',WCRP_TEXT_DOMAIN ), 
));

// Start of Delivery days and date Settings
$form->add_element( 'group', 'pending_payment_reminder', array(
	'value' => __( 'Send Pending Payment Reminder Emails', WCRP_TEXT_DOMAIN ),
	'before' => '<div class="fc-12">',
	'after' => '</div>',
));

$shop_page_markup = array(
	'wc-pending'=>__(' Order With Pending Status', WCRP_TEXT_DOMAIN),
	'wc-on-hold'=>__(' Orders With On-Hold Status', WCRP_TEXT_DOMAIN),
 	);

$form->add_element( 'multiple_checkbox' ,'select_order_status[]', array(
   'lable' => __( 'Select Order Status', WCRP_TEXT_DOMAIN ),
   'value' => $shop_page_markup,
   'current' => isset( $data['select_order_status'] ) ? $data['select_order_status'] : '',
   'class' => 'chkbox_class chkbox-inline',
   'default_value' => 'wc-pending',
));


$form->add_element( 'group', 'error_notification_settings', array(
	'value' => __( 'Error / Notification Messages Settings', WCRP_TEXT_DOMAIN ),
	'before' => '<div class="fc-12">',
	'after' => '</div>',
));

$form->add_element( 'text', 'wcrp_deliverydate_error', array(
	'lable' => __( ' For No Delivery Date Provided', WCRP_TEXT_DOMAIN ),
	'value' => isset( $data['wcrp_deliverydate_error'] ) ? $data['wcrp_deliverydate_error'] :$_POST['wcrp_deliverydate_error'],
	'class' => 'form-control',
	'placeholder' => __('Please specify delivery date for this order.',WCRP_TEXT_DOMAIN),
	'desc'=>__('This error message is displayed on order edit screen if user has not specified an expected delivery date of their order.', WCRP_TEXT_DOMAIN),
	'default_value' => __('Please specify delivery date for this order.',WCRP_TEXT_DOMAIN)

));		

$form->add_element( 'text', 'wcrp_phone_desc', array(
	'lable' => __( 'For No Phone Number Provided', WCRP_TEXT_DOMAIN ),
	'value' => isset( $data['wcrp_phone_desc'] ) ? $data['wcrp_phone_desc'] :$_POST['wcrp_phone_desc'],
	'class' => 'form-control',
	'placeholder' => __('Please enter full mobile number with country code to get notifications.',WCRP_TEXT_DOMAIN),
	'desc' =>__('This notification message is displayed under default phone number field on woocommerce checkout form on frontend to instruct customers to provide their full mobile number with country code to get order related notifications on their mobile. This message is displayed only if you have setup Twilio account information in the above section and also you have enabled "Enable SMS" checkbox from <a href="'.admin_url('admin.php?page=wc-settings&tab=email&section=wc_email_customer_processing_order').'" target="_blank">Here</a> User will need to provide full mobile no. with country code in phone number field on checkout form. For eg +91{mobile-number} is a full mobile no. with country code of India. An SMS will be delivered to customer whenever a new order is placed if your twilio account credentials are correct and other related settings are enabled.',WCRP_TEXT_DOMAIN)

));

$form->add_element( 'group', 'cron_job_settings', array(
	'value' => __( 'Cron Job Settings', WCRP_TEXT_DOMAIN ),
	'before' => '<div class="fc-12">',
	'after' => '</div>',

));

$all_list = array(
	'fc_deliver_woo_reminder_emails'=>__('Earliest',WCRP_TEXT_DOMAIN),
	'hourly'=>__('Hourly',WCRP_TEXT_DOMAIN),
	'twicedaily'=>__('Twice Daily',WCRP_TEXT_DOMAIN),
	'daily'=>__('Daily',WCRP_TEXT_DOMAIN)
);
$form->add_element( 'radio', 'wrcp_cron_setup', array(
	'lable' => __( 'Select Cron Schedule Interval',WCRP_TEXT_DOMAIN ),
	'current' => (isset( $data['wrcp_cron_setup'] ) and ! empty( $data['wrcp_cron_setup'] )) ? $data['wrcp_cron_setup'] : '',
	'radio-val-label' => $all_list,
	'before' => '<div class="fc-8">',
	'after' => '</div>',
	'desc' => __('Select frequency how often you want wordpress to check for pending orders to send pending payment reminder emails or to send product delivery reminder emails. For sites having good traffic twice in a day is sufficient. For sites having low traffic it is recommended to set at Earliest.',WCRP_TEXT_DOMAIN),
));

$form->add_element('submit','wcrp_save_settings',array(
	'value' => __( 'Save Settings ',WCRP_TEXT_DOMAIN ),
	'before' => '<div class="fc-2">',
	'after' => '</div>',
));
$form->add_element('hidden','operation',array(
	'value' => 'save',
));

$main_obj = new WCRP_Reminder();
$last_pending_order= $main_obj->get_last_pending_order();
$last_pending_order_id = isset($data['first_active_oder']) ? $data['first_active_oder'] :$last_pending_order;
	$form->add_element('hidden','first_active_oder',array(
		'value' => $data['first_active_oder'] ,
	));


$form->render();
