<?php
/*
Plugin Name: WooCommerce Reminder Pro
Plugin URI: http://www.flippercode.com/
Description:  Send much needed custom woocommerce reminder emails and sms for pending payments, product delivery notification and product review / post purchase feedback.
Author: flippercode
Author URI: http://www.flippercode.com/
Version: 1.0.6
Text Domain: woocommerce-reminder-pro
Domain Path: /lang/
*/
if ( ! class_exists( 'FC_Plugin_Base' ) ) {
	$pluginClass = plugin_dir_path( __FILE__ ) . '/core/class.plugin.php';
	if ( file_exists( $pluginClass ) )
	include( $pluginClass ); 
}

if (!class_exists('WCRP_Reminder') ) {

	/**
	 * Main plugin class
	 *
	 * @author Flipper Code <hello@flippercode.com>
	 * @package woocommerce-reminder-pro
	 */
	class WCRP_Reminder extends FC_Plugin_Base
	{
		/**
		 * List of Modules.
		 *
		 * @var array
		*/
		private $dboptions;
		private $wooDeliverySettings;
		private $wooReviewSettings;
		private $wooFirstPayReminderSettings;
		private $wooSecondPayReminderSettings;
		private $wooThirdPayReminderSettings;
		private $reminderKeys=array();
		private $new_order_sms_content;
		private $wooProcessingSetting;
		private $enable_new_order_sms = 'yes';
		
		public function __construct() {  
			   
			  error_reporting( E_ERROR | E_PARSE ); 
			   $wooInstalled = in_array( 'woocommerce/woocommerce.php',get_option('active_plugins' ) ) ;
			   if( !$wooInstalled ){
			       add_action( 'admin_notices', array( $this, 'woocommerce_missing' ) );
			    }else{
				    parent::__construct( $this->_plugin_definition() );
				    $this->init();
					$this->_define_constants();
				    $this->register_hooks();
			   }
		  }
		
		function _plugin_definition() {

		  $this->pluginPrefix = 'wcrp';	
		  $pluginClasses = array( 'wcrp-intro.php','wcrp-controller.php','wcrp-model.php','/twilio-phone-verification/twilio.php'); 
		  $pluginModules = array('overview','settings'); 
		  $pluginCssFilesFrontEnd = array(); 
		  $pluginCssFilesBackendEnd = array('select2.css','select2-bootstrap.css'); 
		  $pluginJsFilesFrontEnd = array(); 
		  $pluginJsFilesBackEnd = array('select2.js');
		  $pluginData = array('childFileRefrence' => __FILE__,
							  'childClassRefrence' => __CLASS__,
							  'pluginPrefix' => 'wcrp',
							  'pluginDirectory' => plugin_dir_path( __FILE__ ),
							  'pluginTextDomain' => 'woocommerce-reminder-pro',
							  'pluginURL' =>  plugin_dir_url( __FILE__ ),
							  'dboptions' => 'woocommerce-reminder-pro',
							  'controller' => 'WCRP_Controller',
							  'model' => 'WCRP_Model',
							  'pluginLabel' => 'WooCommerce Reminder Pro',
							  'pluginClasses' =>  $pluginClasses,
							  'pluginmodules' => $pluginModules,
							  'pluginmodulesprefix' => 'WCRP_Model_',
							  'pluginCssFilesFrontEnd' => $pluginCssFilesFrontEnd,
							 'pluginCssFilesBackEnd' => $pluginCssFilesBackendEnd,
							  'pluginJsFilesFrontEnd' => $pluginJsFilesFrontEnd,
							 'pluginJsFilesBackEnd' => $pluginJsFilesBackEnd,
							 'loadCustomizer' => false
							  );
							  
		  return $pluginData;
		  
		}

		public function init() {

			$this->dboptions = maybe_unserialize(get_option( 'woocommerce-reminder-pro' ));
			$this->wooDeliverySettings = maybe_unserialize(get_option('woocommerce_delivery_reminder_settings'));
			$this->wooReviewSettings = maybe_unserialize(get_option('woocommerce_review_pending_reminder_settings'));
			$this->wooFirstPayReminderSettings = maybe_unserialize(get_option('woocommerce_first_payment_reminder_settings'));
			$this->wooSecondPayReminderSettings = maybe_unserialize(get_option('woocommerce_second_payment_reminder_settings'));
			$this->wooThirdPayReminderSettings = maybe_unserialize(get_option('woocommerce_third_payment_reminder_settings'));
			$this->new_order_sms_content = __('New Order #{order_no} received @ {site_name}. Thank You.', 'woocommerce');
			$this->wooProcessingSetting = maybe_unserialize(get_option('woocommerce_customer_processing_order_settings'));

			if(!empty($this->wooProcessingSetting['new_order_sms'])){
				$this->new_order_sms_content = $this->wooProcessingSetting['new_order_sms'];
				$this->enable_new_order_sms  = $this->wooProcessingSetting['sms'];
			}
		}
		
		public function register_hooks() {

			add_action( 'init', array( $this, '_init' ) );
			add_action( 'admin_enqueue_scripts', array($this,'wcrp_admin_enqueue_datetime'));
			add_action('fc_deliver_woo_reminder_emails', array($this,'fc_deliver_woo_reminder_emails' ) );
			add_action( 'restrict_manage_posts', array( $this, 'wcrp_filter_orders' ), 50  );
			add_action( 'load-post.php', array($this,'wcrp_reminder_meta_boxes_setup' ));
			add_action( 'load-post-new.php', array($this,'wcrp_reminder_meta_boxes_setup'));
			add_action('admin_head', array($this, 'placeholder_table_css'));
			add_filter( 'woocommerce_email_classes', array($this,'wcrp_reminders_email_in_woocommerce_settings'));
 			add_filter('cron_schedules',array($this,'wcrp_cron_schedules' ));
 			add_filter('pre_get_posts', array($this,'wcrp_filter_orders_posts'));
			add_action('woocommerce_thankyou', array($this,'deliver_sms_on_order_generation') );
			add_filter( 'woocommerce_email_classes', array($this,'wcrp_enable_sms_new_order'));
			add_filter( 'woocommerce_checkout_fields' , array($this, 'wcrp_override_checkout_fields' ),10,1);
			add_action( 'admin_notices', array($this, 'delivery_date_notice'));

			if(!empty($this->dboptions['delivery_radio_settings']) and $this->dboptions['delivery_radio_settings']=='user'){
				add_action('woocommerce_after_order_notes', array($this,'wcrp_custom_checkout_field'));
		        add_action('woocommerce_checkout_update_order_meta', array($this,'wcrp_custom_checkout_field_update_order_meta'));
			}
		    add_action( 'woocommerce_admin_order_data_after_order_details', array($this,'wcrp_display_order_data_in_admin'));
		    add_action('save_post', array($this,'wcrp_admin_delivery_date_update'));

		    if(!empty($this->dboptions['select_order_status']) and in_array('wc-on-hold', $this->dboptions['select_order_status'])){
		    add_filter('woocommerce_valid_order_statuses_for_payment', array($this,'wcrp_include_hold_payment_link'),10,2);
		    }
		}


		function wcrp_include_hold_payment_link( $array, $instance ) {
			$my_order_status = array('on-hold');       
		    return array_merge($array, $my_order_status);
		}
		
		function wcrp_override_checkout_fields($fields){

			$phone_des = $this->dboptions['wcrp_phone_desc'];
			if(!empty($phone_des))
			$fields['billing']['billing_phone']['description'] =  $phone_des;
			return $fields;
		}

		function wcrp_enable_sms_new_order($emails){

			foreach ($emails as $key => $email) {

					 if( $key == 'WC_Email_Customer_Processing_Order') {

						$email->form_fields['sms'] = array(
							'title'         => __( 'Enable Sms', WCRP_TEXT_DOMAIN ),
							'type'          => 'checkbox',
							'label'         => __( 'Enable this sms notification', WCRP_TEXT_DOMAIN ),
							'default'       => 'yes'
						);
						 $email->form_fields['new_order_sms']=array(

						 'title' =>__('New Order SMS Content','woocommerce'),
						 'type' => 'textarea',
						 'desc_tip' =>__('New Order SMS Content','woocommerce'),
						 'default'=>$this->new_order_sms_content,
						 'rows'=>'20',
						 'desc_tip'=>false,
						 );
						$emails[$key] = $email;
					}
			}
			
			return $emails;
		}
		
		function deliver_sms_on_order_generation($order_id){

			$new_order_sms_meta = get_post_meta($order_id, 'new_order_sms_meta');

			if((!$new_order_sms_meta) and ($this->enable_new_order_sms=='yes')){
				$AccountSid = isset($this->dboptions['wcrp_twilio_accountsid'])?$this->dboptions['wcrp_twilio_accountsid']:'';
				$AuthToken = isset($this->dboptions['wcrp_twilio_authtoken'])?$this->dboptions['wcrp_twilio_authtoken']:'';
				$From  = isset($this->dboptions['wcrp_twilio_from_number']) ? $this->dboptions['wcrp_twilio_from_number'] : '';	
				$order = wc_get_order( $order_id );
				$billingphone = $order->get_billing_phone();
				$sms = $this->new_order_sms_content;
				$toReplace = array(
							'order_no'=>$order_id,
							'site_name'=>get_bloginfo('name'),
							);
			    $sms  = $this->replace_placeholders($sms,$toReplace);
			    $sms  = strip_tags($sms);
				$data = array('to'=>$billingphone,'sms'=>$sms);
				$to   = $data['to'];
				$sms  = $data['sms'];
			    $client = new TwilioRestClient($AccountSid, $AuthToken);
			    $data   = array(
			    	"From" => $From,
			    	"To"   => $to,
			    	"Body" => $sms
			    );

			    $response = $client->request("/2008-08-01/Accounts/$AccountSid/SMS/Messages", "POST", $data);
			    if(!$response->IsError){
			    	update_post_meta($order_id,'new_order_sms_meta','yes');
			    }
			}
      		
		}

		function replace_placeholders($template, $data) {

			$placeholders = array_keys($data);
			foreach ($placeholders as &$placeholder) {
				$placeholder = "{{$placeholder}}";
			}
			return str_replace($placeholders, array_values($data), $template);
		}

		function woocommerce_missing() {
		   ?>
		    <div class="notice notice-error">
		    <p><a target="_blank" href="https://wordpress.org/plugins/woocommerce/">WooCommerce</a><?php _e( ' is required for woocommerce reminder pro plugin. Please install and configure woocommerce first.', WCRP_TEXT_DOMAIN ); ?></p>
		    </div>
		   <?php
		 }

		function placeholder_table_css(){
			?>
			<style>
			table.fc-placeholders-listing{background-color:ivory;width:100%;margin-top: 20px;}	
			table.fc-placeholders-listing td, table.fc-placeholders-listing th {padding: 5px;}
			table.fc-placeholders-listing th {background-color: #212F3D;color:#f1c40f;}
			table.fc-placeholders-listing tr:nth-child(even) {background-color: #f1f1f1;}
			</style>
		<?php
		}		
		
		/**
		 * Schedule multiple cron intervals
		 * @param  [cron interval] $schedules
		 * @return [cron interval]
		 */
		function wcrp_cron_schedules($schedules){

			$schedules['fc_deliver_woo_reminder_emails'] = array(
			'interval' => 15*60,
			'display' => __('Every Fifteen Minutes', WCRP_TEXT_DOMAIN));

			return $schedules;
		}

		function get_last_pending_order(){

			$args = array(
				'posts_per_page'   => 1,
				'offset'           => 0,
				'orderby'          => 'post_date',
				'order'            => 'DESC',
				'post_type'        => 'shop_order',
				'post_status'      => array('wc-pending'),
				'suppress_filters' => true );

			$orders = get_posts( $args );
			if( !empty($orders) )
				return  $orders[0]->ID;

			return false;
		}

		function fc_deliver_woo_reminder_emails() {
			
			$this->load_woo_classes();
			$this->wcrp_review_reminder();
			$this->wcrp_delivery_reminder();
			$this->wcrp_payment_reminder();
		}

		function load_woo_classes(){

				$wooIncludesPath = ABSPATH.'/wp-content/plugins/woocommerce/includes/';
				require_once( $wooIncludesPath.'abstracts/abstract-wc-settings-api.php' );
				require_once( $wooIncludesPath.'libraries/class-emogrifier.php' );
				$wooCommereceDeps = array('class-wc-email.php');
				$wooCorePath = $wooIncludesPath.'emails/';

				foreach($wooCommereceDeps as $wooCoreFile) {
					require_once( $wooCorePath.$wooCoreFile );
				}
				
				if( class_exists('WC_Email') ) {
						
					$plugin_files_to_include = array('wcrp_first_payment_reminder.php',
													 'wcrp_second_payment_reminder.php',
													 'wcrp_third_payment_reminder.php',
													 'wcrp_review_pending_reminder.php',
													 'wcrp_delivery_reminder.php'); 
													 
					foreach ( $plugin_files_to_include as $file ) {

						if ( file_exists( WCRP_PLUGIN_CLASSES . $file ) )
						require_once( WCRP_PLUGIN_CLASSES . $file );
					}

				}
		}
		/**
		*Register Reminders Email Settings in Woocommerce
		*
		*
		**/
		function wcrp_reminders_email_in_woocommerce_settings($email_classes){
			
			$this->load_woo_classes();
			$email_classes['WCRP_First_Payment_Reminder']   = new WCRP_First_Payment_Reminder();
			$email_classes['WCRP_Second_Payment_Reminder']  = new WCRP_Second_Payment_Reminder();
			$email_classes['WCRP_Third_Payment_Reminder']   = new WCRP_Third_Payment_Reminder();
			$email_classes['WCRP_Review_Pending_Reminder']  = new WCRP_Review_Pending_Reminder();
			$email_classes['WCRP_Delivery_Reminder']  		= new WCRP_Delivery_Reminder();
			return $email_classes;
			
		}
		 // Delivery Date settings functions 
		public function wcrp_delivery_date_settings(){
				
		}

		function delivery_date_notice(){
			
			global $current_screen, $pagenow, $post; 
			if(!is_admin())
			return;
			
			if( $current_screen->post_type=='shop_order' and !empty($_GET['action']) and $_GET['action']=='edit'){
			
				if( isset($this->dboptions['select_order_status']) and !empty($this->dboptions['select_order_status']) ){
					 	
					$applied_on = $this->dboptions['select_order_status'];
					
					$order_id= $post->ID;
					$order = wc_get_order( $order_id );
					$order_data = $order->get_data();
					$order_status = $order_data['status'];
					$order_payment_method = $order_data['payment_method'];	
					$delivery_date = get_post_meta($order_id, 'Delivery_Date',true); 
					
					if($order_status != 'completed') {
						
							$delivery_date_error_order_status = apply_filters('fc_wrp_delivery_date_error_order_status',array('pending','on-hold','processing') ); 
							
							if( in_array($order_status,$delivery_date_error_order_status ) ) {
								
								if(empty($delivery_date)){ 
									$delivery_date_error = empty($this->dboptions['wcrp_deliverydate_error']) ?  __( 'Please specify delivery date for this order.',WCRP_TEXT_DOMAIN) : $this->dboptions['wcrp_deliverydate_error'];
									 ?>
									<div class="error notice is-dismissible">
										<p><?php echo $delivery_date_error; ?></p>
									</div>
									<?php
								}
							
							}
						
						}
					}
				
	    	}
	    	
		}
		/*
		Delivery Date update for admin on edit order page 
		 */
		function wcrp_admin_delivery_date_update($post){
			
			global $post;
			if(is_admin()){
				if(isset($post) && ($post->post_type=='shop_order')){
				  $meta_key = 'Delivery_Date';
				  $meta_value=esc_attr($_POST['wcrp_admin_delivery_date']);
				  update_post_meta( $post->ID, $meta_key, $meta_value);
				}
			}
		}
		/*
		Display Delivery date on Order Edit page for admin
		 */
		function wcrp_display_order_data_in_admin( $order ){  
				        
	        if( isset($this->dboptions['select_order_status']) and !empty($this->dboptions['select_order_status']) ){
					
					$applied_on = $this->dboptions['select_order_status'];
					$order_id= $order->get_id();
					$order_data = $order->get_data();
					$order_status = $order_data['status'];
					$order_payment_method = $order_data['payment_method'];
					$delivery_date_control_status = apply_filters('fc_wrp_delivery_date_control_order_status',array('pending','on-hold','processing','completed') ); 		
					if( in_array($order_status,$delivery_date_control_status) ) {	
						$admin_delivery_date = get_post_meta( $order_id, 'Delivery_Date', true);
						echo '<p class="form-field form-field-wide"><label>';
						echo __( 'Set Delivery Date For This Order', WCRP_TEXT_DOMAIN ) .':</label>';
						echo "<input type='text' name='wcrp_admin_delivery_date' id='wcrp_admin_delivery_date' placeholder = 'Set Order Delivery Date ' value='$admin_delivery_date' /></p>";
					}
					
			}
			
		 }
		
		/**
		 * Update custom field value as order meta .
		 */
		function wcrp_custom_checkout_field_update_order_meta($order_id){
			
			if ($_POST['wcrp_user_delivery_date']) 
			update_post_meta( $order_id, 'Delivery_Date', esc_attr($_POST['wcrp_user_delivery_date']));

		}

		/**
		 * Create Custom field on checkout page.
		 */
		function wcrp_custom_checkout_field( $checkout ) {
	
			echo '<div id="wcrp_custom_checkout_field">';

			woocommerce_form_field( 'wcrp_user_delivery_date', array( 
				'type' 			=> 'text', 
				'class' 		=> array('my-field-class orm-row-wide'), 
				'id'			=>'wcrp_user_delivery_date',
				'label' 		=> __('Select you expected Delivery date', WCRP_TEXT_DOMAIN), 
				'placeholder' 	=> __('Please select date', WCRP_TEXT_DOMAIN),
				'required'=>true,
				), $checkout->get_value( 'wcrp_user_delivery_date' ));
			
			echo '</div>';
		}

		// Function for Product Delivery Notification
		public function wcrp_delivery_reminder(){

			global $woocommerce;
			$delivery_reminder_days = $this->wooDeliverySettings['reminderdays'];
			$sms = $this->wooDeliverySettings['sms'];
			$email = $this->wooDeliverySettings['enabled'];
			$deliveryorder = new WCRP_Delivery_Reminder();
			$delivery_reminder_order_status = apply_filters('fc_wrp_deliver_reminder_os',array('wc-processing') );
			$args = array(
			'post_type'			=> 'shop_order',
			'post_status' => $delivery_reminder_order_status,
			'posts_per_page'=>-1
			);

			$loop = new WP_Query($args);
			while ( $loop->have_posts() ) : $loop->the_post();
			$order_id = $loop->post->ID;
			$order = new WC_Order($order_id);
			$deliverydate = get_post_meta($order_id,'Delivery_Date',true);
			if($deliverydate){ 
			$deliverydatet = esc_attr( strtotime($deliverydate) ); 
				if($deliverydatet){

				  $currentt = time(); 
				  $waiting_days_string =  '-'.$delivery_reminder_days.'day';
				  $supposed_ts 		   =  strtotime($waiting_days_string, $deliverydatet);
				  $condition1          =  $currentt>=$supposed_ts; 
				  
					  if($condition1){	
						if( $email =='yes' ){
							 if(!($this->update_reminder_pro_get_notification_key($order_id,'send_delivery_reminder'))) {	
								if($deliveryorder->trigger($order_id))
								$this->update_reminder_pro_notifications($order_id, 'send_delivery_reminder');
							}
						 }// End of email condition
					    if( $sms=='yes' ){
							if(!($this->update_reminder_pro_get_notification_key($order_id,'send_delivery_reminder_sms'))) {
								$success= $deliveryorder->trigger_sms($order_id);
								if($success=='success')
								$this->update_reminder_pro_notifications($order_id, 'send_delivery_reminder_sms');
							}
					    }// End of Sms condition
				 	}

				} //End of Checking timestamp value
			}// End of Checking Delivery Date
			endwhile; 
			wp_reset_query();
		}

		public function wcrp_review_reminder(){

			$wcrp_settings = $this->dboptions;
			$revieworder   = new WCRP_Review_Pending_Reminder();
			$email = $this->wooReviewSettings['enabled'];
			$sms   = $this->wooReviewSettings['sms'];
			$review_reminder_days = $this->wooReviewSettings['reminderdays'];
			$args = array(
				'post_status' => array('wc-completed'),
				'post_type' => 'shop_order',
				'posts_per_page'=>-1
			);
			$loop = new WP_Query($args);	

			while ( $loop->have_posts() ) : $loop->the_post();

				  $order_id = $loop->post->ID;
				  $order = new WC_Order($order_id);
	              $oldt = $order->get_date_modified()->getOffsetTimestamp();

				  $currentt = time(); 
			 	  $waiting_days_string =  $review_reminder_days.'day';
				  $supposed_ts 		   =  strtotime($waiting_days_string, $oldt);
				  $condition1          =  $currentt>$supposed_ts; 
				  $next_fifteen_days   =  strtotime('15 days', $oldt);
				  $condition2          =  $currentt<=$next_fifteen_days;
	
			  if(( $condition2 ) and($condition1) ){
				if($email =='yes'){
						if(!($this->update_reminder_pro_get_notification_key($order_id,'review_mail_send'))) {	
							if($revieworder->trigger($order_id))
							 $this->update_reminder_pro_notifications($order_id, 'review_mail_send');
						}
					}
				if($sms =='yes'){
					if(!($this->update_reminder_pro_get_notification_key($order_id,'send_review_reminder_sms'))) {	
						$status=$revieworder->trigger_sms($order_id);
						 if($status=='success')
						 $this->update_reminder_pro_notifications($order_id, 'send_review_reminder_sms');
					}
				}

			}
			endwhile;
		    wp_reset_query();
		    wp_reset_postdata();

		}

		public function update_reminder_pro_notifications($order_id,$metaKeyToUpdate, $data=true){

			$mainarray = get_post_meta($order_id,'wprp_reminder');
			 if(!$mainarray) {
				 $mainarray = array($metaKeyToUpdate => $data);
			 } else{
				$newKey[$metaKeyToUpdate] = $data;
				if(array_key_exists($metaKeyToUpdate,$mainarray[0])){
					$mainarray[0][$metaKeyToUpdate] = $data;
				}
				$mainarray = array_merge($newKey,$mainarray);
				foreach($mainarray as $key=>$value){
					$mainarray[$key]=$value;
					}
			 }
			 $mainarray = array($metaKeyToUpdate => $data);
			 if(isset($value)){
			 $mainarray = wp_parse_args($value,$mainarray);
			 }
			 update_post_meta($order_id,'wprp_reminder',$mainarray);
			 
		}

		public function update_reminder_pro_get_notification_key($order_id,$metaKeyToUpdate){

			$allNotifications = get_post_meta($order_id,'wprp_reminder');
			if(is_array($allNotifications) and array_key_exists("0",$allNotifications)) {
				$array = $allNotifications['0'];
				
				if(array_key_exists($metaKeyToUpdate,$array) ){
					return $array[$metaKeyToUpdate];
				}
				
				else
				return false;
						
			}
		   return false;
		}


		public function payment_mail_trigger($obj,$order_id,$metakey,$data=true){

			if($obj->trigger($order_id))
			$this->update_reminder_pro_notifications($order_id, $metakey,$data);
			
		}
		public function payment_sms_trigger($obj,$order_id,$metakey, $data=true){

			$status = $obj->trigger_sms($order_id);
			if($status =='success')
			$this->update_reminder_pro_notifications($order_id, $metakey,$data);
		}
		

		public function check_all_pending_reminders($order_id){

			$has_third_Ereminder  = $this->update_reminder_pro_get_notification_key($order_id,'send_third_preminder');
			$has_third_Sreminder  = $this->update_reminder_pro_get_notification_key($order_id,'send_third_spreminder');
			$had_third_Ereminder  = $this->update_reminder_pro_get_notification_key($order_id,'osend_third_preminder');
			$had_third_Sreminder  = $this->update_reminder_pro_get_notification_key($order_id,'osend_third_spreminder');

			if( (($has_third_Sreminder) and ($has_third_Ereminder) ) or (($had_third_Ereminder) and ($had_third_Sreminder) ) ){
				update_post_meta($order_id,'all_reminders_send',time());
			}
		}

		public function wcrp_payment_reminder(){

			$wcrp_settings = $this->dboptions;

			global $woocommerce;
				$args = array(
				'post_type'			=> 'shop_order',
				'posts_per_page'=>-1,
				'meta_query' => array(
								    array(
								     'key' => 'all_reminders_send',
								     'compare' => 'NOT EXISTS'
								    ),
								)
				);

			if(!empty($wcrp_settings['select_order_status']))
				$order_status = $wcrp_settings['select_order_status'];
			else
				$order_status = array();

			$args['post_status'] = $order_status;

			$firstpayReminder  = new WCRP_First_Payment_Reminder();
			$secondpayReminder = new WCRP_Second_Payment_Reminder();
			$thirdpayReminder  = new WCRP_Third_Payment_Reminder();
			$first_acitvate_order_id    = $this->dboptions['first_active_oder'];
			$loop = new WP_Query( $args );
			$firstpay_reminder  = $this->wooFirstPayReminderSettings['reminderdays'];
			$secondpay_reminder = $this->wooSecondPayReminderSettings['reminderdays'];
			$thirdpay_reminder  = $this->wooThirdPayReminderSettings['reminderdays'];
			while ( $loop->have_posts() ) : $loop->the_post();
				
				$order_id = $loop->post->ID;
				$order    = new WC_Order($order_id);
				$oldt     = $order->get_date_created()->getOffsetTimestamp(); 
				$currentt = time(); 
				$payment_method=get_post_meta($order_id,'_payment_method', true);
				
				if(!($payment_method=='cod')){

					$has_third_Ereminder  = $this->update_reminder_pro_get_notification_key($order_id,'send_third_preminder');
					$has_second_Ereminder = $this->update_reminder_pro_get_notification_key($order_id,'send_second_preminder');
					$has_first_Ereminder  = $this->update_reminder_pro_get_notification_key($order_id,'send_first_preminder');
					
					$has_third_Sreminder  = $this->update_reminder_pro_get_notification_key($order_id,'send_third_spreminder');
					$has_second_Sreminder = $this->update_reminder_pro_get_notification_key($order_id,'send_second_spreminder');
					$has_first_Sreminder  = $this->update_reminder_pro_get_notification_key($order_id,'send_first_spreminder');

					$waiting_days1_string    =  $firstpay_reminder.'day';
					$supposed_ts1 		     =  strtotime($waiting_days1_string, $oldt); 
					$waiting_days2_string    =  $secondpay_reminder.'day';
					$supposed_ts2 		     =  strtotime($waiting_days2_string, $oldt);
					$waiting_days3_string    =  $thirdpay_reminder.'day';
					$supposed_ts3 		     =  strtotime($waiting_days3_string, $oldt);
					$next_fifteen_days       =  strtotime('15 days', $oldt);

					$condition31  = ($currentt>=$supposed_ts3) ? true : false;
					$condition32  =  ($condition31 and ($this->wooThirdPayReminderSettings['enabled']=='yes')) ? true : false;
					$condition33  =  (($has_first_Ereminder) and ($has_second_Ereminder) and !($has_third_Ereminder) ) ? true : false;

					$condition32s = ( $condition31 and ($this->wooThirdPayReminderSettings['sms']=='yes') ) ? true : false;
					$condition33s = ( ($has_first_Sreminder) and ($has_second_Sreminder) and !($has_third_Sreminder) ) ? true : false;

					$condition3s =  ( $condition32s and $condition33s ) ? true : false;
					$condition3  = ( $condition32 and $condition33 ) ? true : false;

					$condition21 = ( $currentt>=$supposed_ts2 and $currentt<$supposed_ts3 ) ? true : false;
					$condition22 = ( $condition21 and $this->wooSecondPayReminderSettings['enabled']=='yes') ? true : false;
					$condtion2   = ( $condition22 and !($has_third_Ereminder) and !($has_second_Ereminder) and ($has_first_Ereminder) ) ? true : false;

					$condtion22s = ( $condition21 and $this->wooSecondPayReminderSettings['sms']=='yes') ? true : false;
					$condition2s = ( $condtion22s and ($has_first_Sreminder) and !($has_second_Sreminder) and !($has_second_Sreminder) ) ? true : false;

					$condition11 = ($currentt>=$supposed_ts1 and $currentt<$supposed_ts2) ? true : false;

					$condition12 = ( $condition11 and ($this->wooFirstPayReminderSettings['enabled']=='yes') ) ? true : false;
					
					$condition1  = ( $condition12 and !($has_first_Ereminder) and !($has_second_Ereminder) and !($has_third_Ereminder) ) ? true : false;
					$condition12s = ($condition11 and ($this->wooFirstPayReminderSettings['sms']=='yes')) ? true : false;

					$condition1s  = ($condition12s and ($this->wooFirstPayReminderSettings['sms']=='yes') and !($has_first_Sreminder) and !($has_second_Sreminder) and !($has_third_Sreminder) ) ? true : false;
						
					if($order_id>$first_acitvate_order_id){

						if($condition3){
							$this->payment_mail_trigger($thirdpayReminder,$order_id, 'send_third_preminder');
							$this->check_all_pending_reminders($order_id);
						}

						if($condition3s){
							$this->payment_sms_trigger($thirdpayReminder,$order_id,'send_third_spreminder');
							$this->check_all_pending_reminders($order_id);
						}
				
				  		if($condtion2)
					 		$this->payment_mail_trigger($secondpayReminder,$order_id, 'send_second_preminder');
				  		
				  		if($condition2s)
							$this->payment_sms_trigger($secondpayReminder,$order_id,'send_second_spreminder');

						if($condition1)
						  $this->payment_mail_trigger($firstpayReminder,$order_id, 'send_first_preminder');
						
						if( $condition1s)
							$this->payment_sms_trigger($firstpayReminder,$order_id,'send_first_spreminder');

				}  //
				else{

					if($currentt<$next_fifteen_days){

						$had_first_Ereminder  = $this->update_reminder_pro_get_notification_key($order_id,'osend_first_preminder');
						$had_first_Sreminder  = $this->update_reminder_pro_get_notification_key($order_id,'osend_first_spreminder');

						$had_third_Ereminder  = $this->update_reminder_pro_get_notification_key($order_id,'osend_third_preminder');
						$had_second_Ereminder = $this->update_reminder_pro_get_notification_key($order_id,'osend_second_preminder');
						
						//Checking Sent SMS Reminder
						$had_third_Sreminder  = $this->update_reminder_pro_get_notification_key($order_id,'osend_third_spreminder');
						$had_second_Sreminder = $this->update_reminder_pro_get_notification_key($order_id,'osend_second_spreminder');
						$had_first_Sreminder  = $this->update_reminder_pro_get_notification_key($order_id,'osend_first_spreminder');

						$Osupposed_ts1 		   =  strtotime($waiting_days1_string, $had_first_Ereminder); 

						$Osupposed_ts2 		   =  strtotime($waiting_days2_string, $had_first_Ereminder);

						$Osupposed_ts3 		   =  strtotime($waiting_days3_string, $had_first_Ereminder);

						if(!($had_third_Ereminder) and ($had_second_Ereminder) and ($had_first_Ereminder) and ($currentt>=$Osupposed_ts3) )
						   {
						   		
							   $this->payment_mail_trigger($thirdpayReminder,$order_id, 'osend_third_preminder');
							   $this->check_all_pending_reminders($order_id);
						    }

						if(!($had_third_Sreminder) and ($had_second_Sreminder) and ($had_first_Sreminder) and ($currentt>=$Osupposed_ts3)  )
						{
								$this->payment_sms_trigger($thirdpayReminder,$order_id,'osend_third_spreminder');
								$this->check_all_pending_reminders($order_id);
						}
					
					  	if( ($had_first_Ereminder) and !($had_second_Ereminder) and !($had_third_Ereminder) and ($currentt>=$Osupposed_ts2 and $currentt<$Osupposed_ts3) )
					  	{
						 		$this->payment_mail_trigger($secondpayReminder,$order_id, 'osend_second_preminder');
					  	}
					  		
					  	if(($had_first_Sreminder) and !($had_second_Sreminder) and !($had_third_Sreminder) and ($currentt>=$Osupposed_ts2 and $currentt<$Osupposed_ts3) )
					  	{
								$this->payment_sms_trigger($secondpayReminder,$order_id,'osend_second_spreminder');
					  	}

						if(!($had_first_Ereminder) and !($had_second_Ereminder) and !($had_third_Ereminder) )
						{
							  $this->payment_mail_trigger($firstpayReminder,$order_id, 'osend_first_preminder',$currentt);
						}
							
						if(!($had_first_Sreminder) and !($had_second_Sreminder) and !($had_first_Sreminder)  )
						{
							 $this->payment_sms_trigger($firstpayReminder,$order_id,'osend_first_spreminder',$currentt);
						}
					}
				}

		     }

			endwhile;
			wp_reset_query();
		}

		//Add filter search in admin order listing 
		public function wcrp_filter_orders(){
			
			global $typenow, $wpdb;

				if ( 'shop_order' != $typenow ) {
					return;
				}
					$all_posts = array(
							__('First  Payment Email Reminder',	WCRP_TEXT_DOMAIN )	=>'send_first_preminder',
							__('First  Payment Sms Reminder',	WCRP_TEXT_DOMAIN )	=>'send_first_spreminder',
							__('Second Payment Email Reminder', WCRP_TEXT_DOMAIN )	=>'send_second_preminder',
							__('Second Payment Sms Reminder', 	WCRP_TEXT_DOMAIN )	=>'send_second_spreminder',
							__('Third Payment Email Reminder',	WCRP_TEXT_DOMAIN )	=>'send_third_preminder',
							__('Third Payment Sms Reminder',  	WCRP_TEXT_DOMAIN )	=>'send_third_spreminder',
							__('Delivery Email Reminder',		WCRP_TEXT_DOMAIN )	=>'send_delivery_reminder',
							__('Delivery Sms Reminder', 		WCRP_TEXT_DOMAIN )	=>'send_delivery_reminder_sms',
							__('Review Email Reminder', 		WCRP_TEXT_DOMAIN )	=>'review_mail_send',
							__('Review Sms Reminder', 			WCRP_TEXT_DOMAIN )	=>'send_review_reminder_sms',
					);
				$values = array();
				?>
				<span id="wcrp_order_product_filter_wrap">
					<select name="wcrp_order_product_filter" id="wcrp_order_product_filter">
					<option value="0"><?php _e('Reminders', 'woocommerce-filter-orders-by-product'); ?></option>
					<?php
					$current_v = isset($_GET['wcrp_order_product_filter'])? $_GET['wcrp_order_product_filter']:'';
						foreach ($all_posts as $label => $value) {
							printf
								(	'<option value="%s"%s>%s</option>',
									$value,
									$value == $current_v ? ' selected="selected"':'',
									$label
								);
							}
					?>
					</select>
				</span>
				<?php
					
			}
			// modify where clause in query
			
		function wcrp_filter_orders_posts($query) {
			
			if( is_search() ) {
						global $pagenow;
						$qv = &$query->query_vars;	
						if ( $pagenow == 'edit.php' && isset($qv['post_type']) && $qv['post_type'] == 'shop_order' ) { 
						if ( isset( $_GET['wcrp_order_product_filter'] ) && !empty( $_GET['wcrp_order_product_filter'] ) ) {
							$product = $_GET['wcrp_order_product_filter'];
							$query->set('meta_query',
									array(
										array(
										  'key'     => $product,
										  'compare' => 'EXISTS',
										),
									)
							);	
						}
					}
					
				}
						
			return $query;
		}
		
		function reminder_notification_status_box($order_id){
					
			global $woocommerce;
			$order = new WC_Order( $order_id );
			$src = WCRP_IMAGES;
			$femail  =  $this->update_reminder_pro_get_notification_key($order_id,'send_first_preminder');
			$foemail =  $this->update_reminder_pro_get_notification_key($order_id,'osend_first_preminder');
			$Semail  =  $this->update_reminder_pro_get_notification_key($order_id,'send_second_preminder');
			$Soemail =  $this->update_reminder_pro_get_notification_key($order_id,'osend_second_preminder');

			$Temail  =  $this->update_reminder_pro_get_notification_key($order_id,'send_third_preminder');
			$Toemail =  $this->update_reminder_pro_get_notification_key($order_id,'osend_third_preminder');
			$fsms    =  $this->update_reminder_pro_get_notification_key($order_id,'send_first_spreminder');
			$fosms   =  $this->update_reminder_pro_get_notification_key($order_id,'osend_first_spreminder');
			$Ssms    =  $this->update_reminder_pro_get_notification_key($order_id,'send_second_spreminder');
			$Sosms   =  $this->update_reminder_pro_get_notification_key($order_id,'osend_second_spreminder');
			
			$Tsms   =  $this->update_reminder_pro_get_notification_key($order_id,'send_third_spreminder');
			$Tosms  =  $this->update_reminder_pro_get_notification_key($order_id,'osend_third_spreminder');

			$Demail =  $this->update_reminder_pro_get_notification_key($order_id,'send_delivery_reminder');
			$Dsms   =  $this->update_reminder_pro_get_notification_key($order_id,'send_delivery_reminder_sms');
			$Remail =  $this->update_reminder_pro_get_notification_key($order_id,'review_mail_send');
			$Rsms   =  $this->update_reminder_pro_get_notification_key($order_id,'send_review_reminder_sms');
						?>
			<style type="text/css">
				
				#WooCommerce-reminder-pro h2.hndle{background-color: #bb77ae;color: #fff;}
				#WooCommerce-reminder-pro .handlediv.button-link{color: #fff;}
				.wcrpcomplete{font-size:13px;}
				#WooCommerce-reminder-pro img{width: 15px;vertical-align: middle;}
				span.button{margin-bottom: 5px !important}
			</style>
						<?php 
						//filter according to order status

			$order_status = $order->get_status();

			if($order_status =='pending' or $order_status =='on-hold'){
						
					if($femail or $foemail){
						?>
						<span class="wcrpcomplete" > 
							<p>
							<img src="<?php echo WCRP_IMAGES.'tick.png'; ?>">
							<?php _e('First Payment Reminder Email - Sent', WCRP_TEXT_DOMAIN); ?>
							</p>
						</span>
						<?php
				    }
					if($Semail or $Soemail){
						?>
						<span class="wcrpcomplete">
							<p>
							<img src="<?php echo WCRP_IMAGES.'tick.png'; ?>">
							<?php _e('Second Payment Reminder Email - Sent', WCRP_TEXT_DOMAIN); ?>
							</p>
						</span>
						<?php
					} 
					if($Temail or $Toemail ){
						?>
						<span class="wcrpcomplete">
							<p>
							<img src="<?php echo WCRP_IMAGES.'tick.png'; ?>">
							<?php _e('Third Payment Reminder Email -Sent', WCRP_TEXT_DOMAIN); ?>
							</p>
						</span>
						<?php
					}
					if($fsms or $fosms){
						?>
					<span class="wcrpcomplete">
						<p>
						<img src="<?php echo WCRP_IMAGES.'tick.png'; ?>">
						<?php _e('First Payment Reminder SMS - Sent', WCRP_TEXT_DOMAIN); ?>
						</p>
					</span>
						<?php 
					} 
					if($Ssms or $Sosms){
						?>
						<span class="wcrpcomplete">
							<p>
							   <img src="<?php echo WCRP_IMAGES.'tick.png'; ?>">		
							   <?php _e('Second Payment Reminder SMS - Sent', WCRP_TEXT_DOMAIN); ?>
							</p>
						</span>
						<?php 
					} 
					if($Tsms or $Tosms){
						?>
						<span class="wcrpcomplete">
							<p>
								<img src="<?php echo WCRP_IMAGES.'tick.png'; ?>">
								<?php _e('Third Payment Reminder SMS - Sent', WCRP_TEXT_DOMAIN); ?>
							</p>
						</span>
						<?php 
						
					}
					
				}//End of pending order status condition
					
				if($order_status =='processing'){
					if($Demail){
						?>
				<span class="wcrpcomplete">
					<p>
						<img src="<?php echo WCRP_IMAGES.'tick.png'; ?>">
						<?php _e('Order Delivery Reminder Email', WCRP_TEXT_DOMAIN); ?>
					</p>
				</span>
						<?php
					} 
					if($Dsms){
						?>
					<span class="wcrpcomplete">
						<p><img src="<?php echo WCRP_IMAGES.'tick.png'; ?>">
						<?php _e('Order Delivery Reminder SMS', WCRP_TEXT_DOMAIN); ?>
						</p>
					 </span>
						<?php
				    }
			     }//End of processing order condtion
						
				 if($order_status =='completed'){
							
					if($Remail){
						?>
					<span class="wcrpcomplete">
						<p><img src="<?php echo WCRP_IMAGES.'tick.png'; ?>"><?php _e('Product Review Reminder Email', WCRP_TEXT_DOMAIN); ?></p>
					</span>
						<?php
					} 
					if($Rsms){
						?>
					<span class="wcrpcomplete">
						<p><img src="<?php echo WCRP_IMAGES.'tick.png'; ?>"><?php _e('Product Review Reminder SMS', WCRP_TEXT_DOMAIN); ?></p>
					</span>
						<?php
					}
					 
				  } //End of completed order condtion

		}
		// Adding meta boxes at order meta screen
		function wcrp_reminder_meta_boxes_setup(){

				add_action( 'add_meta_boxes', array($this,'wcrp_add_post_meta_boxes') );
		}
		
		function wcrp_get_post_meta_value($order_id, $key){
			
			$value = get_post_meta($order_id,$key, true);
			return $value;
		}
		
		function wcrp_add_post_meta_boxes(){
			
			global $woocommerce, $post;
			
			if($post->post_type == 'shop_order')  {
				
			$order = new WC_Order($post->ID);

			$order_id = $order->get_id();

			$femail  = $this->update_reminder_pro_get_notification_key($order_id,'send_first_preminder');
			$foemail = $this->update_reminder_pro_get_notification_key($order_id,'osend_first_preminder');
			$fosmail = $this->update_reminder_pro_get_notification_key($order_id,'osend_first_spreminder');
			$Semail  = $this->update_reminder_pro_get_notification_key($order_id,'send_second_preminder');
			$Soemail = $this->update_reminder_pro_get_notification_key($order_id,'osend_second_preminder');
			$Sosms   = $this->update_reminder_pro_get_notification_key($order_id,'osend_second_spreminder');
			$Temail  = $this->update_reminder_pro_get_notification_key($order_id,'send_third_preminder');
			$Toemail = $this->update_reminder_pro_get_notification_key($order_id,'osend_third_preminder');
			$fsms    = $this->update_reminder_pro_get_notification_key($order_id,'send_first_spreminder');
			$Ssms    = $this->update_reminder_pro_get_notification_key($order_id,'send_second_spreminder');
			$Tsms    = $this->update_reminder_pro_get_notification_key($order_id,'send_third_spreminder');
			$Tosms   = $this->update_reminder_pro_get_notification_key($order_id,'osend_third_spreminder');
			$Demail  = $this->update_reminder_pro_get_notification_key($order_id,'send_delivery_reminder');
			$Dsms    = $this->update_reminder_pro_get_notification_key($order_id,'send_delivery_reminder_sms');
			$Remail  = $this->update_reminder_pro_get_notification_key($order_id,'review_mail_send');
			$Rsms    = $this->update_reminder_pro_get_notification_key($order_id,'send_review_reminder_sms');

			$order_status =  $order->get_status();
			switch($order_status)
			{
				case 'pending':
					
				if(($femail) or ($foemail) or ($Semail) or ($Soemail)  or ($Temail) or ($Toemail)  or ($fsms) or ($fosmail) or ($Ssms) or ($Sosms) or ($Tsms) or ($Tosms) ){
					add_meta_box('WooCommerce-reminder-pro', esc_html__( 'WooCommerce Reminder Pro', WCRP_TEXT_DOMAIN ), array($this,'wcrp_reminder_meta_box'), 'shop_order','side', 'high');	
				}
				break;

				case 'on-hold':
					
				if(($femail) or ($foemail) or ($Semail) or ($Soemail)  or ($Temail) or ($Toemail)  or ($fsms) or ($fosmail) or ($Ssms) or ($Sosms) or ($Tsms) or ($Tosms) ){
					add_meta_box('WooCommerce-reminder-pro', esc_html__( 'WooCommerce Reminder Pro', WCRP_TEXT_DOMAIN ), array($this,'wcrp_reminder_meta_box'), 'shop_order','side', 'high');	
				}
				break;
				
				case 'completed':
				if(($Remail) or ($Rsms)){
					 add_meta_box('WooCommerce-reminder-pro', esc_html__( 'WooCommerce Reminder Pro', WCRP_TEXT_DOMAIN ), array($this,'wcrp_reminder_meta_box'), 'shop_order','side', 'high');	
				}
				break;
				
				case 'processing':
				if(($Demail) or ($Dsms)){
					add_meta_box('WooCommerce-reminder-pro', esc_html__( 'WooCommerce Reminder Pro', WCRP_TEXT_DOMAIN ), array($this,'wcrp_reminder_meta_box'), 'shop_order','side', 'high');	
				}
				break;
					
				default:
				
		  }

		}
		  	
		  
		}
		
		function wcrp_reminder_meta_box($object, $box){
					
	 	  wp_nonce_field( basename( __FILE__ ), 'wcrp_reminder_pro_nonce' ); 
	 	  ?>
	 	  <p>  <?php $this->reminder_notification_status_box($object->ID);  ?> </p>
		  <?php
		  
		 }

		/**
		 * Call WordPress hooks.
		 */
		function _init() {
			
			if ( ! is_admin() )
			add_action( 'wp_enqueue_scripts', array( $this, 'wcrp_frontend_scripts' ) );
			//$this->wcrp_delivery_date_settings();

		}

		/**
		 * Eneque Common scripts .
		 */
		
		public function get_common_scripts(){
			
			wp_enqueue_script( 'jquery' );

			$scripts[] = array(
			'handle'  => 'wcrp-jqueryui',
			'src'   => WCRP_JS . 'jquery-ui.min.js',
			'deps'    => array(),
			);
			$scripts[] = array(
			'handle'  => 'wcrp-jqueryuitimepickeraddon',
			'src'   => WCRP_JS . 'jquery-ui-timepicker-addon.js',
			'deps'    => array(),
			);
			$scripts[] = array(
			'handle'  => 'wcrp-jqueryuislideraccess',
			'src'   => WCRP_JS . 'jquery-ui-sliderAccess.js',
			'deps'    => array(),
			);
			$scripts[] = array(
			'handle'  => 'wcrp-datetimescript',
			'src'   => WCRP_JS . 'dateandtimescript.js',
			'deps'    => array(),
			);

			return $scripts;

		}
		
		function wcrp_admin_enqueue_datetime($post){
			global $post;

			wp_enqueue_script( 'wcrp-backend', WCRP_JS .'wcrp_backend.js');

			if(!empty($post->post_type) and ($post->post_type == 'shop_order')){

				$frontend_styles = array(
				'wcrp_jqueryui'  =>'http://code.jquery.com/ui/1.10.3/themes/smoothness/jquery-ui.css',
				);

				if ( $frontend_styles ) {
					foreach ( $frontend_styles as $frontend_style_key => $frontend_style_value ) {
						wp_enqueue_style( $frontend_style_key, $frontend_style_value );
					}
				}

				$scripts = $this->get_common_scripts();
				$scripts[] = array(
				'handle'  => 'wcrp-backend',
				'src'   => WCRP_JS .'wcrp_backend.js',
				'deps'    => array(),
				);

				$where = apply_filters( 'wcrp_script_position', true );
				if ( $scripts ) {
					foreach ( $scripts as $script ) {
						wp_enqueue_script( $script['handle'], $script['src'], $script['deps'], '', $where );
					}
				}
				$wcrp_settings = array('gaptime'=>$this->dboptions['set_delivery_days'],
					'ajax_url'=>admin_url('admin-ajax.php'));
				
				wp_localize_script( 'wcrp-datetimescript', 'wcrp_settings', $wcrp_settings );

			}

		}


		/**
		 * Enquue Scripts at frontend
		 */
		function wcrp_frontend_scripts() {
			
			$frontend_styles = array(
			'wcrp_jqueryui'  =>'http://code.jquery.com/ui/1.10.3/themes/smoothness/jquery-ui.css'
			);

			if ( $frontend_styles ) {
				foreach ( $frontend_styles as $frontend_style_key => $frontend_style_value ) {
					wp_enqueue_style( $frontend_style_key, $frontend_style_value );
				}
			}

			$scripts = $this->get_common_scripts();
			
			$where = apply_filters( 'wcrp_script_position', true );
			if ( $scripts ) {
				foreach ( $scripts as $script ) {
					wp_enqueue_script( $script['handle'], $script['src'], $script['deps'], '', $where );
				}
			}
				
			$wcrp_settings = array('gaptime'=>$this->dboptions['set_delivery_days'],
				'ajax_url'=>admin_url('admin-ajax.php'));
			
			wp_localize_script( 'wcrp-datetimescript', 'wcrp_settings', $wcrp_settings );

		}

		function define_admin_menu() {

			$pagehook = add_menu_page(
				__( 'WooCommerce Reminder Pro', WCRP_TEXT_DOMAIN ),
				__( 'WooCommerce Reminder Pro', WCRP_TEXT_DOMAIN ),
				'wcrp_admin_overview',
				WCRP_SLUG,
				array( $this,'processor' ),
				WCRP_IMAGES.'fc-small-logo.png'
			);
			return $pagehook;
		}

		/**
		 * Perform tasks on plugin deactivation.
		 */
		function plugin_deactivation_work() {

			 wp_clear_scheduled_hook('fc_deliver_woo_reminder_emails');

		}

		/**
		 * Perform tasks on plugin deactivation.
		 */
		function plugin_activation_work() {

			require_once( ABSPATH . 'wp-admin/includes/upgrade.php' );

			
			/*
			 * Setup Default Values On Initialisation 
			 */
			 
			$wcrp_settings        = $this->dboptions ;
			$wcrp_dwoosettings    = $this->wooDeliverySettings;
			$wcrpRwooSettings     = $this->wooReviewSettings;
			$wcrpThirdPaySettings = $this->wooThirdPayReminderSettings;
			$wcrpSecPaySettings   = $this->wooSecondPayReminderSettings;
			$wcrpFirstPaySettings = $this->wooFirstPayReminderSettings;
			
			$default_data=array();

			$default_data['set_delivery_days']=isset($wcrp_settings['set_delivery_days'])?$wcrp_settings['set_delivery_days']:5;

			$default_data['delivery_radio_settings']=isset($wcrp_settings['delivery_radio_settings'])?$wcrp_settings['set_delivery_days']:'admin';

			$default_data['select_order_status']=isset($wcrp_settings['select_order_status'])?$wcrp_settings['select_order_status']:array('wc-pending','wc-on-hold');

			$default_data['wrcp_cron_setup']=isset($wcrp_settings['wrcp_cron_setup'])?$wcrp_settings['wrcp_cron_setup']:'fc_deliver_woo_reminder_emails';
			
			$default_data['wcrp_deliverydate_error']=isset($wcrp_settings['wcrp_deliverydate_error'])?$wcrp_settings['wcrp_deliverydate_error']:'Please enter an expected delivery date for this order.';
			
			$default_data['wcrp_phone_desc']=isset($wcrp_settings['wcrp_phone_desc'])?$wcrp_settings['wcrp_phone_desc']:'Please enter full mobile no. with country code to get notifications.';
			
			$last_pending_order = $this->get_last_pending_order();
			if(!empty($last_pending_order) and empty($wcrp_settings['first_active_oder'])){

				$default_data['first_active_oder']=isset($wcrp_settings['first_active_oder'])?$wcrp_settings['first_active_oder']:$last_pending_order;
			}

			if(!empty($wcrp_settings)){
				foreach ($wcrp_settings as $key=>$settings) {
					if(!empty($wcrp_settings[$key])){
						$default_data[$key] = $wcrp_settings[$key];
					}
				}
			}
			if(empty($wcrp_settings) or array_key_exists('version', $wcrp_settings))
				update_option( 'woocommerce-reminder-pro', serialize( wp_unslash( $default_data ) ) );
			
			//Delivery Notification reminder Settings on activation
			$deliverySettings= array(  
			'enabled'	   => isset($wcrp_dwoosettings['enabled']) ? $wcrp_dwoosettings['enabled'] : 'yes',
			'sms' 		   => isset($wcrp_dwoosettings['sms']) ? $wcrp_dwoosettings['sms']: 'No',
			'reminderdays' => isset($wcrp_dwoosettings['reminderdays']) ? $wcrp_dwoosettings['reminderdays']:0,
			'subject' 	   => isset($wcrp_dwoosettings['subject']) ? $wcrp_dwoosettings['subject']: 'Delivery Reminder {site_title}',
			'heading' 	   => isset($wcrp_dwoosettings['heading']) ? $wcrp_dwoosettings['heading']: 'Product Delivery Reminder',
			'email_type'   => isset($wcrp_dwoosettings['email_type']) ? $wcrp_dwoosettings['email_type']: 'html',
			'mail_body'    => isset($wcrp_dwoosettings['mail_body']) ? $wcrp_dwoosettings['mail_body']: 'This is product delivery reminder email regarding your order #{order_no} @ site {site_name}. <br>
			You have following products in your order :<br>
			{order_info_table}<br>
			Products will be shipped {delivery_date_difference} later on your shipping address.<br><br>
			{delivery_date}<br>
			{customer_details}<br>
			{billing_details}<br>
			<br><br>
			Thank You.<br>
			{site_name}',
			'sms_content'  => isset($wcrp_dwoosettings['sms_content']) ? $wcrp_dwoosettings['sms_content']: 'Dear {billing_first_name},<br><br>
				Your Order will deliver today : # {order_no} Thank you dear-{site_name}<br><br>'
			);

			$drs = get_option('woocommerce_delivery_reminder_settings');
			if(!$drs)
			update_option( 'woocommerce_delivery_reminder_settings', $deliverySettings);
			
			//Review reminder Settings on activation
			$reviewSettings= Array(
			'subject' 	   => isset($wcrpRwooSettings['subject']) ? $wcrpRwooSettings['subject']: 'Review Your Purchase.',
			'enabled' 	 => isset($wcrpRwooSettings['enabled']) ? $wcrpRwooSettings['enabled'] :'yes',
			'sms' 		   => isset($wcrpRwooSettings['sms']) ? $wcrpRwooSettings['sms']: 'No',
			'reminderdays' => isset($wcrpRwooSettings['reminderdays']) ? $wcrpRwooSettings['reminderdays']:7,
			'heading' 	   => isset($wcrpRwooSettings['heading'])?$wcrpRwooSettings['heading']: 'Provide Your Valuable Feedbacks',
			'email_type'   => isset($wcrpRwooSettings['email_type']) ? $wcrpRwooSettings['email_type']: 'html',
			'mail_body'    => isset($wcrpRwooSettings['mail_body']) ?$wcrpRwooSettings['mail_body']: 'Hello {billing_first_name}<br><br>
							Thank you for purchasing {products_name} on {site_name}. We\'d love if you help us or other customers by reviewing the product you recently purchased.<br><br>
							It\'d take hardly 5 minutes and it would help other customers to know your experience with the product.{email_review_links}<br>
							Thank You.<br>
							{site_name}',
			'sms_content'  => isset($wcrpRwooSettings['sms_content']) ? $wcrpRwooSettings['sms_content'] : 'Dear {billing_first_name},Please leave a feedback for Order : # {order_no} Thank you -{site_name}');
			$rrs = get_option('woocommerce_review_pending_reminder_settings');
			if(!$rrs)
			update_option( 'woocommerce_review_pending_reminder_settings', $reviewSettings);
			
			//Thirdpayment reminder Settings on activation
			$thirdPaySettings=Array(
			'enabled' 	   => isset($wcrpThirdPaySettings['enabled']) ? $wcrpThirdPaySettings['enabled']: 'yes',
			'sms'		   => isset($wcrpThirdPaySettings['sms']) ? $wcrpThirdPaySettings['sms']: 'No',
			'reminderdays' => isset($wcrpThirdPaySettings['reminderdays']) ? $wcrpThirdPaySettings['reminderdays']:15,
			'subject'	   => isset($wcrpThirdPaySettings['subject']) ? $wcrpThirdPaySettings['subject']: 'Third Payment Reminder',
			'heading' 	   => isset($wcrpThirdPaySettings['heading']) ? $wcrpThirdPaySettings['heading']: 'Third Payment Reminder',
			'email_type'   => isset($wcrpThirdPaySettings['email_type']) ? $wcrpThirdPaySettings['email_type']: 'html', 
			'mail_body'    => isset($wcrpThirdPaySettings['mail_body']) ? $wcrpThirdPaySettings['mail_body']:'Hello {billing_first_name} {billing_last_name},<br><br>
			This is Third pending payment reminder for an order #{order_no} that you have placed at our site {site_name}.
			Please make payment using below link so that we can ship the products on your specified billing address.<br>
			{payment_link}<br><br>
			{order_info_table}<br>
			{customer_details}<br>
			{billing_details}<br>
			<br><br>
			Thanks<br>
			{site_name}',
			'sms_content'  => isset($wcrpThirdPaySettings['sms_content']) ? $wcrpThirdPaySettings['sms_content']: 'Please make payment for order #{order_no}  @ {site_name} to get all products shipped.');
											
			$tpr = get_option('woocommerce_third_payment_reminder_settings');
			if(!$tpr)
			update_option( 'woocommerce_third_payment_reminder_settings', $thirdPaySettings);
			
			//Secondpayment reminder Settings on activation
			$SecPaySettings=Array(
			'enabled' 	   => isset($wcrpSecPaySettings['enabled'])?$wcrpSecPaySettings['enabled']: 'yes',
			'sms'          => isset($wcrpSecPaySettings['sms']) ? $wcrpSecPaySettings['sms']: 'No',
			'reminderdays' => isset($wcrpSecPaySettings['reminderdays']) ? $wcrpSecPaySettings['reminderdays']:7,
			'subject'      => isset($wcrpSecPaySettings['subject']) ? $wcrpSecPaySettings['subject']: 'Second Payment Reminder',
			'heading'      => isset($wcrpSecPaySettings['heading']) ? $wcrpSecPaySettings['heading']: 'Second Payment Reminder',
			'email_type'   => isset($wcrpSecPaySettings['email_type']) ? $wcrpSecPaySettings['email_type']: 'html', 
			'mail_body'    => isset($wcrpSecPaySettings['mail_body'] )? $wcrpSecPaySettings['mail_body']: 'Hello {billing_first_name} {billing_last_name},<br><br>
				This is Second pending payment reminder for an order #{order_no} that you have placed at our site {site_name}.
				Please make payment using below link so that we can ship the products on your specified billing address.<br>
				{payment_link}<br><br>
				{order_info_table}<br>
				{customer_details}<br>
				{billing_details}<br>
				<br><br>
				Thanks<br>
				{site_name}',
			'sms_content'  => isset($wcrpSecPaySettings['sms_content']) ? $wcrpSecPaySettings['sms_content']: 'Please make payment for order #{order_no}  @ {site_name} to get all products shipped.');
											
			$spr = get_option('woocommerce_second_payment_reminder_settings');
			if(!$spr)
			update_option( 'woocommerce_second_payment_reminder_settings', $SecPaySettings);
			
			//First payment reminder Settings on activation
			$FirstPaySettings=array(
			'enabled'	   => isset($wcrpFirstPaySettings['enabled']) ? $wcrpFirstPaySettings['enabled']: 'yes',
			'sms' 		   => isset($wcrpFirstPaySettings['sms']) ? $wcrpFirstPaySettings['sms']: 'No',
			'reminderdays' => isset($wcrpFirstPaySettings['reminderdays']) ? $wcrpFirstPaySettings['reminderdays']: '3',
			'subject' 	   => isset($wcrpFirstPaySettings['subject']) ? $wcrpFirstPaySettings['subject']: 'First Payment Reminder',
			'heading'      => isset($wcrpFirstPaySettings['heading']) ? $wcrpFirstPaySettings['heading']: 'First Payment Reminder',
			'email_type'   => isset($wcrpFirstPaySettings['email_type']) ? $wcrpFirstPaySettings['email_type']: 'html', 
			'mail_body'    => isset($wcrpFirstPaySettings['mail_body']) ? $wcrpFirstPaySettings['mail_body']: 'Hello {billing_first_name} {billing_last_name},<br><br>
				This is First pending payment reminder for an order #{order_no} that you have placed at our site {site_name}.
				Please make payment using below link so that we can ship the products on your specified billing address.<br>
				{payment_link}<br><br>
				{order_info_table}<br>
				{customer_details}<br>
				{billing_details}<br>
				<br><br>
				Thanks<br>
				{site_name}',
			'sms_content'  => isset($wcrpFirstPaySettings['sms_content']) ? $wcrpFirstPaySettings['sms_content']:'Please make payment for order #{order_no}  @ {site_name} to get all products shipped.');
											
			$fpr = get_option('woocommerce_first_payment_reminder_settings');
			if(!$fpr)
			update_option( 'woocommerce_first_payment_reminder_settings', $FirstPaySettings);
			
			$this->register_woo_reminder_pro_event();
			//Cron Setup

		}
		
		function register_woo_reminder_pro_event() {
			
			if (! wp_next_scheduled ( 'fc_deliver_woo_reminder_emails' ))
			wp_schedule_event(time(), 'fc_deliver_woo_reminder_emails', 'fc_deliver_woo_reminder_emails');
			
		}

		/**
		 * Define all constants.
		 */
		  function _define_constants() {

			global $wpdb;

			if ( ! defined( 'WCRP_SLUG' ) ) {
				define( 'WCRP_SLUG', 'wcrp_view_overview' );
			}
			if ( ! defined( 'WCRP_PREMIUM' ) ) {
				define( 'WCRP_PREMIUM', 'true' );
			}
			if ( ! defined( 'WCRP_VERSION' ) ) {
				define( 'WCRP_VERSION', '1.0.6' );
			}

			if ( ! defined( 'WCRP_TEXT_DOMAIN' ) ) {
				define( 'WCRP_TEXT_DOMAIN', 'woocommerce-reminder-pro' );
			}

			if ( ! defined( 'WCRP_FOLDER' ) ) {
				define( 'WCRP_FOLDER', basename( dirname( __FILE__ ) ) );
			}

			if ( ! defined( 'WCRP_DIR' ) ) {
				define( 'WCRP_DIR', plugin_dir_path( __FILE__ ) );
			}

			if ( ! defined( 'WCRP_CORE_CLASSES' ) ) {
				define( 'WCRP_CORE_CLASSES', WCRP_DIR . 'core/' );
			}

			if ( ! defined( 'WCRP_PLUGIN_CLASSES' ) ) {
				define( 'WCRP_PLUGIN_CLASSES', WCRP_DIR . 'classes/' );
			}

			if ( ! defined( 'WCRP_CONTROLLER' ) ) {
				define( 'WCRP_CONTROLLER', WCRP_CORE_CLASSES );
			}

			if ( ! defined( 'WCRP_CORE_CONTROLLER_CLASS' ) ) {
				define( 'WCRP_CORE_CONTROLLER_CLASS', WCRP_CORE_CLASSES . 'class.controller.php' );
			}

			if ( ! defined( 'WCRP_MODEL' ) ) {
				define( 'WCRP_MODEL', WCRP_DIR . 'modules/' );
			}

			if ( ! defined( 'WCRP_URL' ) ) {
				define( 'WCRP_URL', plugin_dir_url( WCRP_FOLDER ) . WCRP_FOLDER . '/' );
			}

			if ( ! defined( 'WCRP_INC_URL' ) ) {
				define( 'WCRP_INC_URL', WCRP_URL . 'includes/' );
			}

			if ( ! defined( 'WCRP_CSS' ) ) {
				define( 'WCRP_CSS', WCRP_URL . '/assets/css/' );
			}

			if ( ! defined( 'WCRP_JS' ) ) {
				define( 'WCRP_JS', WCRP_URL . '/assets/js/' );
			}

			if ( ! defined( 'WCRP_IMAGES' ) ) {
				define( 'WCRP_IMAGES', WCRP_URL . '/assets/images/' );
			}

			if ( ! defined( 'WCRP_FONTS' ) ) {
				define( 'WCRP_FONTS', WCRP_URL . 'fonts/' );
			}
			if ( ! defined( 'WCRP_TBL_FORM' ) ) {
				define( 'WCRP_TBL_FORM', $wpdb->prefix . 'wcrp_pro' );
			}
		}

	}

    new WCRP_Reminder();
}
