<?php
/**
 * Hook to Woo Tools to add buttons for missing rafs.
 * @author    WPGens
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class WPGENS_RAF_Tools {

	public function __construct() {
		// Hook in WooCommerce debug tools.
		add_filter( 'woocommerce_debug_tools', array($this, 'gens_tools') );
	}

	/**
	 * Woocommerce tools button to add missing referrals.
	 *
	 * @since 2.0.0
	 */
	public function gens_tools($old) {
		$new = array(
			'gens_add_missing_referrals' => array(
				'name'    => __( 'Refer a friend - Create missing referral links.', 'gens-raf' ),
				'button'  => __( 'Create referrals', 'gens-raf' ),
				'desc'    => __( '<strong class="red">Note:</strong> This tool will add missing referrals to your site prior to users clicking on my account page. Useful if you want to inform users about their referral link, before it was autogenerated by them visiting page with referral link. ', 'gens-raf' ),
				'callback' => array($this,'gens_add_missing_referrals')
			),
			'gens_reset_referral_data' => array(
				'name'    => __( 'Refer a friend - Reset referral data.', 'gens-raf' ),
				'button'  => __( 'Reset referrals', 'gens-raf' ),
				'desc'    => __( '<strong class="red">Note:</strong> This tool will remove all referral data from orders and will reset number of referrals for each user. Use with caution! Coupons will be kept by users, but if some referrals are pending, they wont award coupons after this. Backup your store before clicking!', 'gens-raf' ),
				'callback' => array($this,'gens_reset_referral_data')
			),
		);
		$tools = array_merge( $old, $new );
		return $tools;
	}
	
	/**
	 * Callback function for Woocommerce tools button to reset referral data. 
	 * This will remove all metas on orders.
	 *
	 * @since 2.0.0
	 */
	function gens_reset_referral_data() {

		$return = delete_post_meta_by_key('_raf_id');
		delete_post_meta_by_key('_raf_meta');
		$users = get_users();
	    foreach ($users as $user) {
	        delete_user_meta($user->ID, 'gens_num_friends');
	    }
		if($return === true) {
			echo '<div class="updated inline"><p>Removed all referral data for orders.</p></div>';
		} else {
			echo '<div class="updated inline"><p>Nothing to remove.</p></div>';
		}

	}

	/**
	 * Callback function for Woocommerce tools button to add missing referrals.
	 *
	 * @since 2.0.0
	 */
	function gens_add_missing_referrals() {
		$gens_user_query = new WP_User_Query(array( 'meta_key' => 'gens_referral_id', 'meta_compare' => 'NOT EXISTS' ));
		$users = $gens_user_query->get_results();
		foreach ($users as $user) {
			WPGens_RAF_User::new_user_add_referral_id($user->ID);
		}
		echo '<div class="updated inline"><p>' . count($users) . __( ' missing referral codes have been created', 'gens-raf' ) . '</p></div>';
	}

}

new WPGENS_RAF_Tools();